/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.services;

import de.iip_ecosphere.platform.services.environment.services.TransportConverter;
import de.iip_ecosphere.platform.services.environment.services.TransportToWsConverter;
import de.iip_ecosphere.platform.services.environment.services.WsAdapter;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;
import java.net.URI;
import java.util.function.Consumer;

class WsWatcher<T>
extends WsAdapter
implements TransportConverter.Watcher<T> {
    private Consumer<T> consumer = d -> {};
    private TypeTranslator<T, String> typeTranslator;

    public WsWatcher(URI serverUri, TypeTranslator<T, String> typeTranslator) {
        super(serverUri, TransportToWsConverter.getLogger());
        this.typeTranslator = typeTranslator;
    }

    @Override
    public TransportConverter.Watcher<T> start() {
        this.connect();
        return this;
    }

    @Override
    public TransportConverter.Watcher<T> stop() {
        this.close();
        return this;
    }

    @Override
    protected void onMessage(String message) {
        try {
            Object data = this.typeTranslator.from((Object)message);
            this.consumer.accept(data);
        }
        catch (IOException e) {
            TransportToWsConverter.getLogger().error("While ingesting result data: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void setConsumer(Consumer<T> consumer) {
        this.consumer = null == consumer ? d -> {} : consumer;
    }
}

