/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas.config;

import de.iip_ecosphere.platform.support.PidFile;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.setup.AbstractSetup;
import de.iip_ecosphere.platform.support.yaml.Yaml;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.function.Supplier;

public class RuntimeSetup
extends AbstractSetup {
    private static RuntimeSetup instance;
    private String aasRegistry;
    private String smRegistry;
    private String aasServer;
    private String smServer;

    public String getAasRegistry() {
        return this.aasRegistry;
    }

    public void setAasRegistry(String aasRegistry) {
        this.aasRegistry = aasRegistry;
    }

    public String getSubmodelRegistry() {
        return this.smRegistry;
    }

    public void setSubmodelRegistry(String smRegistry) {
        this.smRegistry = smRegistry;
    }

    public String getAasServer() {
        return this.aasServer;
    }

    public void setAasServer(String aasServer) {
        this.aasServer = aasServer;
    }

    public String getSubmodelServer() {
        return this.smServer;
    }

    public void setSubmodelServer(String smServer) {
        this.smServer = smServer;
    }

    public static File getFile() {
        return new File(PidFile.getPidDirectory(), "oktoflow.yaml");
    }

    public void store() {
        try (FileWriter writer = new FileWriter(RuntimeSetup.getFile());){
            Yaml.getInstance().dump((Object)this, RuntimeSetup.class, (Writer)writer);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(RuntimeSetup.class).warn("Cannot write platform runtime setup {}: {} Ephemeral AAS ports may not work.", (Object)RuntimeSetup.getFile(), (Object)e.getMessage());
        }
    }

    public static void clear() {
        instance = null;
    }

    public static RuntimeSetup load() {
        return RuntimeSetup.load(() -> new RuntimeSetup(), true);
    }

    public static synchronized RuntimeSetup load(Supplier<RuntimeSetup> onFailure, boolean logOnFailure) {
        if (null == instance) {
            try (FileInputStream in = new FileInputStream(RuntimeSetup.getFile());){
                instance = (RuntimeSetup)((Object)AbstractSetup.readFromYaml(RuntimeSetup.class, (InputStream)in));
                LoggerFactory.getLogger(RuntimeSetup.class).info("Considering runtime setup from {}", (Object)RuntimeSetup.getFile());
            }
            catch (IOException e) {
                if (logOnFailure) {
                    LoggerFactory.getLogger(RuntimeSetup.class).warn("Cannot read platform runtime setup {}: {} Ephemeral AAS ports may not work.", (Object)RuntimeSetup.getFile(), (Object)e.getMessage());
                }
                instance = onFailure.get();
            }
        }
        return instance;
    }
}

