/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReference;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IReferenceElement;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;

public class BaSyxReferenceElement
extends BaSyxSubmodelElement
implements ReferenceElement {
    private IReferenceElement reference;

    private BaSyxReferenceElement() {
    }

    BaSyxReferenceElement(IReferenceElement reference) {
        this.reference = reference;
    }

    IReferenceElement getReferenceElement() {
        return this.reference;
    }

    public String getIdShort() {
        try {
            return this.reference.getIdShort();
        }
        catch (ResourceNotFoundException e) {
            return "";
        }
    }

    public Reference getValue() {
        try {
            return new BaSyxReference(this.reference.getValue());
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    IReferenceElement getSubmodelElement() {
        return this.reference;
    }

    public void accept(AasVisitor visitor) {
        visitor.visitReferenceElement((ReferenceElement)this);
    }

    public String getSemanticId(boolean stripPrefix) {
        return Tools.translateReference(this.reference.getSemanticId(), stripPrefix);
    }

    public void setSemanticId(String semanticId) {
        IReference ref = Tools.translateReference(semanticId);
        if (ref != null && this.reference instanceof org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.ReferenceElement) {
            ((org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.ReferenceElement)this.reference).setSemanticId(ref);
        }
    }

    public static class BaSyxReferenceElementBuilder
    implements ReferenceElement.ReferenceElementBuilder {
        private BaSyxSubmodelElementContainerBuilder<?> parentBuilder;
        private BaSyxReferenceElement instance;
        private org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.ReferenceElement reference;

        BaSyxReferenceElementBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, String idShort) {
            if (null == idShort || 0 == idShort.length()) {
                throw new IllegalArgumentException("idShort must be given");
            }
            this.parentBuilder = parentBuilder;
            this.instance = new BaSyxReferenceElement();
            this.reference = new org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.ReferenceElement();
            this.reference.setIdShort(idShort);
        }

        public BaSyxSubmodelElementContainerBuilder<?> getParentBuilder() {
            return this.parentBuilder;
        }

        public ReferenceElement build() {
            this.instance.reference = this.reference;
            return this.parentBuilder.register(this.instance);
        }

        public ReferenceElement.ReferenceElementBuilder setValue(Reference value) {
            if (!(value instanceof BaSyxReference)) {
                throw new IllegalArgumentException("value must be of type reference");
            }
            this.reference.setValue(((BaSyxReference)value).getReference());
            return this;
        }

        public ReferenceElement.ReferenceElementBuilder setSemanticId(String refValue) {
            IReference ref = Tools.translateReference(refValue);
            if (ref != null) {
                this.reference.setSemanticId(ref);
            }
            return this;
        }

        public ReferenceElement.ReferenceElementBuilder setDescription(LangString ... description) {
            this.reference.setDescription(Tools.translate(description));
            return this;
        }
    }
}

