/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx.security;

import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.web.filter.OncePerRequestFilter;

public class FailNoAuthorizationFilter
extends OncePerRequestFilter {
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private Pattern uriException;
    private boolean allowAnonymous;

    public FailNoAuthorizationFilter() {
        this(null, false);
    }

    public FailNoAuthorizationFilter(String exceptionUriRegEx, boolean allowAnonymous) {
        this.uriException = null == exceptionUriRegEx ? null : Pattern.compile(exceptionUriRegEx);
        this.allowAnonymous = allowAnonymous;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication existingAuth = this.securityContextHolderStrategy.getContext().getAuthentication();
        if (null == existingAuth) {
            if (null != this.uriException && this.uriException.matcher(request.getRequestURI()).matches()) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else if (this.allowAnonymous) {
                AuthenticationDescriptor.DefaultRole role = AuthenticationDescriptor.DefaultRole.NONE;
                AnonymousAuthenticationToken token = new AnonymousAuthenticationToken(role.name(), (Object)role.name(), List.of(new SimpleGrantedAuthority(role.name())));
                token.setDetails((Object)role);
                this.securityContextHolderStrategy.getContext().setAuthentication((Authentication)token);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                response.setStatus(401);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

