/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.AssetInformation;
import de.iip_ecosphere.platform.support.aas.BlobDataElement;
import de.iip_ecosphere.platform.support.aas.DataElement;
import de.iip_ecosphere.platform.support.aas.Entity;
import de.iip_ecosphere.platform.support.aas.FileDataElement;
import de.iip_ecosphere.platform.support.aas.MultiLanguageProperty;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Range;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.RelationshipElement;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementList;
import java.util.concurrent.ExecutionException;

public class AasPrintVisitor
implements AasVisitor {
    private String indentation = "";

    private void increaseIndentation() {
        this.indentation = this.indentation + " ";
    }

    private void decreaseIndentation() {
        if (this.indentation.length() > 0) {
            this.indentation = this.indentation.substring(0, this.indentation.length() - 1);
        }
    }

    private void log(String text) {
        System.out.println(this.indentation + text);
    }

    @Override
    public void visitAas(Aas aas) {
        this.log("AAS " + aas.getIdShort() + " [" + aas.getIdentification() + "]");
        this.increaseIndentation();
    }

    @Override
    public void endAas(Aas aas) {
        this.decreaseIndentation();
    }

    @Override
    public void visitAsset(AssetInformation asset) {
        this.log("ASSET " + asset.getIdShort() + " " + String.valueOf((Object)asset.getAssetKind()));
    }

    @Override
    public void visitSubmodel(Submodel submodel) {
        this.log("SUBMODEL " + submodel.getIdShort() + " [" + submodel.getIdentification() + "]");
        this.increaseIndentation();
    }

    @Override
    public void endSubmodel(Submodel submodel) {
        this.decreaseIndentation();
    }

    @Override
    public void visitProperty(Property property) {
        String value;
        try {
            value = String.valueOf(property.getValue());
        }
        catch (ExecutionException e) {
            value = "?";
        }
        Object semId = property.getSemanticId();
        semId = null == semId ? "" : " (semanticId: " + (String)semId + ")";
        this.log("PROPERTY " + property.getIdShort() + " = " + value + (String)semId);
    }

    @Override
    public void visitOperation(Operation operation) {
        this.log("OPERATION " + operation.getIdShort() + " #args " + operation.getArgsCount());
    }

    @Override
    public void visitReferenceElement(ReferenceElement referenceElement) {
        this.log("REFERENCE " + referenceElement.getIdShort() + " = " + String.valueOf(referenceElement.getValue()));
    }

    @Override
    public void visitSubmodelElementCollection(SubmodelElementCollection collection) {
        this.log("COLLECTION " + collection.getIdShort());
        this.increaseIndentation();
    }

    @Override
    public void endSubmodelElementCollection(SubmodelElementCollection collection) {
        this.decreaseIndentation();
    }

    @Override
    public void visitSubmodelElementList(SubmodelElementList list) {
        this.log("LIST " + list.getIdShort());
        this.increaseIndentation();
    }

    @Override
    public void endSubmodelElementList(SubmodelElementList list) {
        this.decreaseIndentation();
    }

    @Override
    public void visitDataElement(DataElement dataElement) {
        this.log("DATAELT " + dataElement.getIdShort());
    }

    @Override
    public void visitFileDataElement(FileDataElement dataElement) {
        this.log("FILEDATAELT " + dataElement.getIdShort());
    }

    @Override
    public void visitRange(Range range) {
        this.log("RANGE " + String.valueOf(range.getMin()) + " " + String.valueOf(range.getMax()));
    }

    @Override
    public void visitBlobDataElement(BlobDataElement dataElement) {
        this.log("BLOBDATAELT " + dataElement.getIdShort());
    }

    @Override
    public void visitMultiLanguageProperty(MultiLanguageProperty property) {
        this.log("MLP " + property.getIdShort());
    }

    @Override
    public void visitRelationshipElement(RelationshipElement relationship) {
        this.log("RELATIONSHIP " + relationship.getIdShort());
    }

    @Override
    public void visitEntity(Entity entity) {
        this.log("ENTITY " + entity.getIdShort());
        this.increaseIndentation();
    }

    @Override
    public void endVisitEntity(Entity entity) {
        this.decreaseIndentation();
    }
}

