/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.aggregator.observing;

import java.util.Collection;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.aggregator.observing.IAASAggregatorObserver;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.observer.Observable;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class ObservableAASAggregator
extends Observable<IAASAggregatorObserver>
implements IAASAggregator {
    private IAASAggregator aasAggregator;

    public ObservableAASAggregator(IAASAggregator aggregator) {
        this.aasAggregator = aggregator;
    }

    @Override
    public Collection<IAssetAdministrationShell> getAASList() {
        return this.aasAggregator.getAASList();
    }

    @Override
    public IAssetAdministrationShell getAAS(IIdentifier aasId) throws ResourceNotFoundException {
        return this.aasAggregator.getAAS(aasId);
    }

    @Override
    public IModelProvider getAASProvider(IIdentifier aasId) throws ResourceNotFoundException {
        return this.aasAggregator.getAASProvider(aasId);
    }

    @Override
    public void createAAS(AssetAdministrationShell aas) {
        this.aasAggregator.createAAS(aas);
        this.observers.stream().forEach(o -> o.aasCreated(aas.getIdentification().getId()));
    }

    @Override
    public void updateAAS(AssetAdministrationShell aas) throws ResourceNotFoundException {
        this.aasAggregator.updateAAS(aas);
        this.observers.stream().forEach(o -> o.aasUpdated(aas.getIdentification().getId()));
    }

    @Override
    public void deleteAAS(IIdentifier aasId) {
        this.aasAggregator.deleteAAS(aasId);
        this.observers.stream().forEach(o -> o.aasDeleted(aasId.getId()));
    }
}

