/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.aasx;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File;

public class SubmodelFileEndpointLoader {
    public static void setRelativeFileEndpoints(ISubmodel submodel, String host, int port, String path) {
        String fileRoot = "http://" + host + ":" + port + path;
        SubmodelFileEndpointLoader.setRelativeFileEndpoints(submodel, fileRoot);
    }

    public static void setRelativeFileEndpoints(ISubmodel submodel, String fileRoot) {
        Map<String, ISubmodelElement> elements = submodel.getSubmodelElements();
        SubmodelFileEndpointLoader.setMapEndpoints(elements, fileRoot);
    }

    private static void setMapEndpoints(Map<String, ISubmodelElement> elements, String fileRoot) {
        elements.values().stream().forEach(e -> {
            if (e instanceof File) {
                File file = (File)e;
                SubmodelFileEndpointLoader.setFileEndpoint(file, fileRoot);
            } else if (e instanceof ISubmodelElementCollection) {
                SubmodelElementCollection col = (SubmodelElementCollection)e;
                SubmodelFileEndpointLoader.setMapEndpoints(col.getSubmodelElements(), fileRoot);
            }
        });
    }

    private static void setFileEndpoint(File file, String fileRoot) {
        String relativePath = file.getValue();
        try {
            URL url = new URL(file.getValue());
            relativePath = url.getPath();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String newEndpoint = fileRoot + relativePath;
        file.setValue(newEndpoint);
    }
}

