/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.directory.tagged.map;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.memory.AASRegistry;
import org.eclipse.basyx.aas.registration.memory.IRegistryHandler;
import org.eclipse.basyx.aas.registration.memory.MapRegistryHandler;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.IAASTaggedDirectory;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedAASDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedSubmodelDescriptor;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;

public class MapTaggedDirectory
extends AASRegistry
implements IAASTaggedDirectory {
    protected Map<String, Set<TaggedAASDescriptor>> tagMap;
    private Map<String, Set<TaggedSubmodelDescriptor>> submodelTagMap = new LinkedHashMap<String, Set<TaggedSubmodelDescriptor>>();
    private static final String WILDCARD = "*";

    public MapTaggedDirectory(Map<String, AASDescriptor> rootMap, Map<String, Set<TaggedAASDescriptor>> tagMap) {
        super(new MapRegistryHandler(rootMap));
        this.tagMap = tagMap;
    }

    public MapTaggedDirectory(IRegistryHandler registryHandler, Map<String, Set<TaggedAASDescriptor>> tagMap) {
        super(registryHandler);
        this.tagMap = tagMap;
    }

    @Override
    public void register(TaggedAASDescriptor descriptor) {
        super.register(descriptor);
        this.addTags(descriptor);
        Collection<SubmodelDescriptor> submodelDescriptors = descriptor.getSubmodelDescriptors();
        for (SubmodelDescriptor smDesc : submodelDescriptors) {
            TaggedSubmodelDescriptor taggedSmDesc = TaggedSubmodelDescriptor.createAsFacade(smDesc);
            Set<String> tags = taggedSmDesc.getTags();
            if (tags == null || tags.isEmpty()) continue;
            this.addSubmodelTags(taggedSmDesc);
        }
    }

    @Override
    public void registerSubmodel(IIdentifier aas, TaggedSubmodelDescriptor descriptor) {
        super.register(aas, descriptor);
        this.addSubmodelTags(descriptor);
    }

    protected void addSubmodelTags(TaggedSubmodelDescriptor descriptor) {
        descriptor.getTags().stream().forEach(t -> this.addSubmodelTag((String)t, descriptor));
    }

    private synchronized void addSubmodelTag(String submodelTag, TaggedSubmodelDescriptor descriptor) {
        this.submodelTagMap.computeIfAbsent(submodelTag, key -> new LinkedHashSet()).add(descriptor);
    }

    public void deleteSubmodelTag(IIdentifier aasIdentifier, IIdentifier smIdentifier) {
        SubmodelDescriptor submodelDescriptor = super.lookupSubmodel(aasIdentifier, smIdentifier);
        super.delete(aasIdentifier, smIdentifier);
        Set tags = (Set)submodelDescriptor.get("tags");
        tags.stream().forEach(t -> this.submodelTagMap.get(t).remove(submodelDescriptor));
    }

    @Override
    public Set<TaggedSubmodelDescriptor> lookupBothAasAndSubmodelTags(Set<String> aasTags, Set<String> submodelTags) {
        if (aasTags.isEmpty() || submodelTags.isEmpty() || aasTags.contains(WILDCARD) && submodelTags.contains(WILDCARD)) {
            return Collections.emptySet();
        }
        if (aasTags.contains(WILDCARD)) {
            return this.lookupSubmodelTags(submodelTags);
        }
        if (submodelTags.contains(WILDCARD)) {
            return this.lookupAllSubmodelDescriptorsForAasTags(aasTags);
        }
        return this.lookupCombinedTags(aasTags, submodelTags);
    }

    private Set<TaggedSubmodelDescriptor> lookupCombinedTags(Set<String> aasTags, Set<String> submodelTags) {
        LinkedHashSet<TaggedSubmodelDescriptor> result = new LinkedHashSet<TaggedSubmodelDescriptor>();
        Set<TaggedAASDescriptor> aasDescriptors = this.lookupTags(aasTags);
        Set<TaggedSubmodelDescriptor> smDescriptors = this.lookupSubmodelTags(submodelTags);
        for (TaggedAASDescriptor aasDesc : aasDescriptors) {
            for (TaggedSubmodelDescriptor smDesc : smDescriptors) {
                if (aasDesc.getSubmodelDescriptorFromIdentifierId(smDesc.getIdentifier().getId()) == null) continue;
                result.add(smDesc);
            }
        }
        return result;
    }

    private Set<TaggedSubmodelDescriptor> lookupAllSubmodelDescriptorsForAasTags(Set<String> aasTags) {
        LinkedHashSet<TaggedSubmodelDescriptor> result = new LinkedHashSet<TaggedSubmodelDescriptor>();
        Set<TaggedAASDescriptor> desc = this.lookupTags(aasTags);
        for (TaggedAASDescriptor descriptor : desc) {
            for (SubmodelDescriptor smDesc : descriptor.getSubmodelDescriptors()) {
                result.add(TaggedSubmodelDescriptor.createAsFacade(smDesc));
            }
        }
        return result;
    }

    @Override
    public Set<TaggedSubmodelDescriptor> lookupSubmodelTag(String submodelTag) {
        if (this.submodelTagMap.containsKey(submodelTag)) {
            return new LinkedHashSet<TaggedSubmodelDescriptor>((Collection)this.submodelTagMap.get(submodelTag));
        }
        return new LinkedHashSet<TaggedSubmodelDescriptor>();
    }

    @Override
    public Set<TaggedSubmodelDescriptor> lookupSubmodelTags(Set<String> submodelTags) {
        LinkedHashSet<TaggedSubmodelDescriptor> result = new LinkedHashSet<TaggedSubmodelDescriptor>();
        result.addAll(this.getMatchingSubmodelDescriptors(submodelTags));
        return result;
    }

    private Set<TaggedSubmodelDescriptor> getMatchingSubmodelDescriptors(Set<String> submodelTags) {
        LinkedHashSet<TaggedSubmodelDescriptor> result = new LinkedHashSet<TaggedSubmodelDescriptor>();
        LinkedHashSet<TaggedSubmodelDescriptor> smDescriptors = new LinkedHashSet<TaggedSubmodelDescriptor>();
        for (String s : submodelTags) {
            smDescriptors.addAll(this.lookupSubmodelTag(s));
        }
        for (TaggedSubmodelDescriptor desc : smDescriptors) {
            if (!desc.getTags().containsAll(submodelTags)) continue;
            result.add(desc);
        }
        return result;
    }

    @Override
    public Set<TaggedAASDescriptor> lookupTag(String tag) {
        if (this.tagMap.containsKey(tag)) {
            return new LinkedHashSet<TaggedAASDescriptor>((Collection)this.tagMap.get(tag));
        }
        return new LinkedHashSet<TaggedAASDescriptor>();
    }

    @Override
    public Set<TaggedAASDescriptor> lookupTags(Set<String> tags) {
        Set<TaggedAASDescriptor> result = new LinkedHashSet<TaggedAASDescriptor>();
        Set descriptors = tags.stream().map(t -> this.lookupTag((String)t)).collect(Collectors.toSet());
        if (descriptors.size() > 0) {
            Iterator it = descriptors.iterator();
            result = (Set)it.next();
            while (it.hasNext()) {
                result.retainAll((Collection)it.next());
            }
        }
        return result;
    }

    @Override
    public void delete(IIdentifier aasIdentifier) {
        AASDescriptor desc = super.lookupAAS(aasIdentifier);
        super.delete(aasIdentifier);
        if (this.isTaggedAASDescriptor(desc)) {
            TaggedAASDescriptor.createAsFacade(desc).getTags().stream().forEach(t -> this.tagMap.get(t).remove(desc));
        }
    }

    private boolean isTaggedAASDescriptor(AASDescriptor desc) {
        return desc.containsKey("tags");
    }

    protected void addTags(TaggedAASDescriptor descriptor) {
        descriptor.getTags().stream().forEach(t -> this.addTag((String)t, descriptor));
    }

    private synchronized void addTag(String tag, TaggedAASDescriptor descriptor) {
        if (!this.tagMap.containsKey(tag)) {
            this.tagMap.put(tag, new LinkedHashSet());
        }
        this.tagMap.get(tag).add(descriptor);
    }
}

