/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.aggregator.mqtt;

import java.util.Map;
import org.eclipse.basyx.extensions.shared.mqtt.MqttEventService;
import org.eclipse.basyx.extensions.submodel.aggregator.mqtt.MqttV2SubmodelAggregatorTopicFactory;
import org.eclipse.basyx.submodel.aggregator.observing.ISubmodelAggregatorObserverV2;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.coder.json.serialization.Serializer;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttV2SubmodelAggregatorObserver
extends MqttEventService
implements ISubmodelAggregatorObserverV2 {
    private static Logger logger = LoggerFactory.getLogger(MqttV2SubmodelAggregatorObserver.class);
    private MqttV2SubmodelAggregatorTopicFactory topicFactory;
    private Serializer payloadSerializer;

    public MqttV2SubmodelAggregatorObserver(MqttClient client, MqttV2SubmodelAggregatorTopicFactory topicFactory) throws MqttException {
        this(client, topicFactory, MqttV2SubmodelAggregatorObserver.createGSONTools());
    }

    public MqttV2SubmodelAggregatorObserver(MqttClient client, MqttV2SubmodelAggregatorTopicFactory topicFactory, Serializer payloadSerializer) throws MqttException {
        super(client);
        this.topicFactory = topicFactory;
        this.payloadSerializer = payloadSerializer;
        logger.info("Create new MQTT Submodel Aggregator Observer for endpoint " + client.getServerURI());
    }

    private static GSONTools createGSONTools() {
        return new GSONTools(new DefaultTypeFactory(), false, false);
    }

    @Override
    public void submodelCreated(String shellId, ISubmodel submodel, String repoId) {
        if (submodel instanceof Map) {
            ISubmodel copy = this.removeSubmodelElements(submodel);
            this.sendMqttMessage(this.topicFactory.createCreateSubmodelTopic(shellId, repoId), this.serializePayload(copy));
        } else {
            this.sendMqttMessage(this.topicFactory.createCreateSubmodelTopic(shellId, repoId), this.serializePayload(submodel));
        }
    }

    @Override
    public void submodelUpdated(String shellId, ISubmodel submodel, String repoId) {
        if (submodel instanceof Map) {
            ISubmodel copy = this.removeSubmodelElements(submodel);
            this.sendMqttMessage(this.topicFactory.createUpdateSubmodelTopic(shellId, repoId), this.serializePayload(copy));
        } else {
            this.sendMqttMessage(this.topicFactory.createUpdateSubmodelTopic(shellId, repoId), this.serializePayload(submodel));
        }
    }

    @Override
    public void submodelDeleted(String shellId, ISubmodel submodel, String repoId) {
        if (submodel instanceof Map) {
            ISubmodel copy = this.removeSubmodelElements(submodel);
            this.sendMqttMessage(this.topicFactory.createDeleteSubmodelTopic(shellId, repoId), this.serializePayload(copy));
        } else {
            this.sendMqttMessage(this.topicFactory.createDeleteSubmodelTopic(shellId, repoId), this.serializePayload(submodel));
        }
    }

    private ISubmodel removeSubmodelElements(ISubmodel submodel) {
        Map<String, Object> map = SubmodelElementMapCollectionConverter.smToMap((Submodel)submodel);
        Submodel copy = Submodel.createAsFacade(map);
        for (ISubmodelElement sme : submodel.getSubmodelElements().values()) {
            copy.deleteSubmodelElement(sme.getIdShort());
        }
        return copy;
    }

    private String serializePayload(ISubmodel submodel) {
        return this.payloadSerializer.serialize(submodel);
    }
}

