/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.reference;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.vab.model.VABModelMap;

public class Key
extends VABModelMap<Object>
implements IKey {
    public static final String TYPE = "type";
    public static final String LOCAL = "local";
    public static final String VALUE = "value";
    public static final String IDTYPE = "idType";

    public Key(KeyElements type, boolean local, String value, KeyType idType) {
        this.put(TYPE, type.toString());
        this.put(LOCAL, Boolean.valueOf(local));
        this.put(VALUE, value);
        this.put(IDTYPE, idType.toString());
    }

    public Key(KeyElements type, boolean local, String value, IdentifierType idType) {
        this(type, local, value, KeyType.fromString(idType.toString()));
    }

    private Key() {
    }

    public static Key createAsFacade(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        if (!Key.isValid(map)) {
            throw new MetamodelConstructionException(Key.class, map);
        }
        Key ret = new Key();
        ret.setMap(map);
        return ret;
    }

    public static boolean isValid(Map<String, Object> map) {
        return map != null && map.containsKey(TYPE) && map.containsKey(LOCAL) && map.containsKey(VALUE) && map.containsKey(IDTYPE);
    }

    public static boolean isKey(Object value) {
        if (!(value instanceof Map)) {
            return false;
        }
        Map map = (Map)value;
        if (!(map.get(LOCAL) instanceof Boolean && map.get(VALUE) instanceof String && map.get(IDTYPE) instanceof String && map.get(TYPE) instanceof String)) {
            return false;
        }
        try {
            KeyType.fromString((String)map.get(IDTYPE));
            KeyElements.fromString((String)map.get(TYPE));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @Override
    public KeyElements getType() {
        return KeyElements.fromString((String)this.get(TYPE));
    }

    @Override
    public boolean isLocal() {
        return (Boolean)this.get(LOCAL);
    }

    @Override
    public String getValue() {
        return (String)this.get(VALUE);
    }

    @Override
    public KeyType getIdType() {
        return KeyType.fromString((String)this.get(IDTYPE));
    }

    public void setType(KeyElements type) {
        this.put(TYPE, type.toString());
    }

    public void setLocal(boolean local) {
        this.put(LOCAL, Boolean.valueOf(local));
    }

    public void setValue(String value) {
        this.put(VALUE, value);
    }

    public void setIdType(KeyType idType) {
        this.put(IDTYPE, idType.toString());
    }

    @Override
    public String toString() {
        return "Key [getType()=" + this.getType() + ", isLocal()=" + this.isLocal() + ", getValue()=" + this.getValue() + ", getIdType()=" + this.getIdType() + "]";
    }
}

