/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.modelprovider.map;

import java.util.Collection;
import java.util.Map;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceAlreadyExistsException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.generic.IVABElementHandler;

public class VABMapHandler
implements IVABElementHandler {
    @Override
    public Object getElementProperty(Object element, String propertyName) {
        if (element instanceof Map) {
            Map map = (Map)element;
            if (!map.containsKey(propertyName)) {
                throw new ResourceNotFoundException("Property \"" + propertyName + "\" does not exist.");
            }
            return map.get(propertyName);
        }
        if (element instanceof Collection || element instanceof Object[]) {
            throw new ResourceNotFoundException("It is not possible to access single elements in lists.");
        }
        throw new MalformedRequestException("Could not get property \"" + propertyName + "\".");
    }

    @Override
    public void setModelPropertyValue(Object element, String propertyName, Object newValue) throws ProviderException {
        if (!(element instanceof Map)) {
            if (element instanceof Collection || element instanceof Object[]) {
                throw new ResourceNotFoundException("It is not possible to set single elements in lists.");
            }
            throw new MalformedRequestException("Could not set property \"" + propertyName + "\".");
        }
        Map map = (Map)element;
        map.put(propertyName, newValue);
    }

    @Override
    public void createValue(Object element, Object newValue) {
        if (!(element instanceof Collection)) {
            throw new ResourceAlreadyExistsException("Could not create property.");
        }
        Collection collection = (Collection)element;
        collection.add(newValue);
    }

    @Override
    public void deleteValue(Object element, String propertyName) {
        Map map;
        if (element instanceof Map) {
            map = (Map)element;
            if (!map.containsKey(propertyName)) {
                throw new ResourceNotFoundException("Property \"" + propertyName + "\" does not exist. Therefore it can not be deleted.");
            }
        } else {
            if (element instanceof Collection || element instanceof Object[]) {
                throw new ResourceNotFoundException("It is not possible to remove elements from a list using an index.");
            }
            throw new MalformedRequestException("Could not delete property \"" + propertyName + "\".");
        }
        map.remove(propertyName);
    }

    @Override
    public void deleteValue(Object element, Object property) {
        if (!(element instanceof Collection)) {
            throw new MalformedRequestException("Could not delete object from property.");
        }
        ((Collection)element).remove(property);
    }
}

