/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.common;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.paho.mqttv5.common.packet.MqttDisconnect;

public class MqttException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final short REASON_CODE_CLIENT_EXCEPTION = 0;
    public static final int REASON_CODE_INVALID_IDENTIFIER = 50000;
    public static final int REASON_CODE_INVALID_RETURN_CODE = 50001;
    public static final int REASON_CODE_MALFORMED_PACKET = 50002;
    public static final int REASON_CODE_UNSUPPORTED_PROTOCOL_VERSION = 50003;
    public static final int REASON_CODE_INVALID_TOPIC_ALAS = 50004;
    public static final int REASON_CODE_DUPLICATE_PROPERTY = 50005;
    private int reasonCode;
    private Throwable cause;
    private String disconnectReasonString;
    private int disconnectReasonCode = 0;

    public MqttException(int reasonCode) {
        this.reasonCode = reasonCode;
    }

    public MqttException(int reasonCode, MqttDisconnect disconnect) {
        this.reasonCode = reasonCode;
        if (disconnect != null) {
            this.disconnectReasonCode = disconnect.getReturnCode();
            if (disconnect.getProperties() != null) {
                this.disconnectReasonString = disconnect.getProperties().getReasonString();
            }
        }
    }

    public MqttException(Throwable cause) {
        this.reasonCode = 0;
        this.cause = cause;
    }

    public MqttException(int reason, Throwable cause) {
        this.reasonCode = reason;
        this.cause = cause;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public String getMessage() {
        String message;
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.paho.mqttv5.common.nls.messages");
        try {
            message = bundle.getString(Integer.toString(this.reasonCode));
        }
        catch (MissingResourceException missingResourceException) {
            message = "Untranslated MqttException - RC: " + this.reasonCode;
        }
        if (this.disconnectReasonCode != 0) {
            message = String.valueOf(message) + " Disconnect RC: " + this.disconnectReasonCode;
        }
        if (this.disconnectReasonString != null) {
            message = String.valueOf(message) + " Disconnect Reason: " + this.disconnectReasonString;
        }
        return message;
    }

    @Override
    public String toString() {
        String result = String.valueOf(this.getMessage()) + " (" + this.reasonCode + ")";
        if (this.cause != null) {
            result = String.valueOf(result) + " - " + this.cause.toString();
        }
        return result;
    }
}

