/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap.ioc;

import com.google.inject.AbstractModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SingletonModule<T>
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(SingletonModule.class);
    protected T key;

    public SingletonModule(T key) {
        this.key = key;
    }

    public boolean equals(Object obj) {
        return obj instanceof SingletonModule && ((SingletonModule)((Object)obj)).key.equals(this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "(key=" + this.key.toString() + ")";
    }

    public void instantiateOnStartup(Class<?> clazz) {
        log.trace("Instantiating {} as eager singleton", (Object)clazz.getCanonicalName());
        this.bind(clazz).asEagerSingleton();
    }
}

