/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap.netty;

import com.hivemq.bootstrap.netty.ExceptionHandler;
import com.hivemq.codec.decoder.MqttConnectDecoder;
import com.hivemq.codec.decoder.MqttDecoders;
import com.hivemq.codec.encoder.EncoderFactory;
import com.hivemq.codec.encoder.MQTTMessageEncoder;
import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.configuration.service.RestrictionsConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.handler.ClientLifecycleEventHandler;
import com.hivemq.extensions.handler.IncomingPublishHandler;
import com.hivemq.extensions.handler.IncomingSubscribeHandler;
import com.hivemq.extensions.handler.PluginInitializerHandler;
import com.hivemq.logging.EventLog;
import com.hivemq.metrics.MetricsHolder;
import com.hivemq.metrics.handler.GlobalMQTTMessageCounter;
import com.hivemq.mqtt.handler.InterceptorHandler;
import com.hivemq.mqtt.handler.auth.AuthHandler;
import com.hivemq.mqtt.handler.auth.AuthInProgressMessageHandler;
import com.hivemq.mqtt.handler.connack.MqttConnacker;
import com.hivemq.mqtt.handler.connect.ConnectHandler;
import com.hivemq.mqtt.handler.connect.ConnectionLimiterHandler;
import com.hivemq.mqtt.handler.connect.NoConnectIdleHandler;
import com.hivemq.mqtt.handler.disconnect.DisconnectHandler;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.handler.ping.PingRequestHandler;
import com.hivemq.mqtt.handler.publish.MessageExpiryHandler;
import com.hivemq.mqtt.handler.publish.PublishFlushHandler;
import com.hivemq.mqtt.handler.subscribe.SubscribeHandler;
import com.hivemq.mqtt.handler.unsubscribe.UnsubscribeHandler;
import com.hivemq.security.ssl.SslParameterHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import javax.inject.Inject;
import javax.inject.Provider;

public class ChannelDependencies {
    @NotNull
    private final NoConnectIdleHandler noConnectIdleHandler;
    @NotNull
    private final Provider<ConnectHandler> connectHandlerProvider;
    @NotNull
    private final ConnectionLimiterHandler connectionLimiterHandler;
    @NotNull
    private final DisconnectHandler disconnectHandler;
    @NotNull
    private final Provider<SubscribeHandler> subscribeHandlerProvider;
    @NotNull
    private final UnsubscribeHandler unsubscribeHandler;
    @NotNull
    private final ChannelGroup channelGroup;
    @NotNull
    private final FullConfigurationService fullConfigurationService;
    @NotNull
    private final GlobalTrafficShapingHandler globalTrafficShapingHandler;
    @NotNull
    private final MetricsHolder metricsHolder;
    @NotNull
    private final ExceptionHandler exceptionHandler;
    @NotNull
    private final PingRequestHandler pingRequestHandler;
    @NotNull
    private final RestrictionsConfigurationService restrictionsConfigurationService;
    @NotNull
    private final MqttConnectDecoder mqttConnectDecoder;
    @NotNull
    private final MqttConnacker mqttConnacker;
    @NotNull
    private final MQTTMessageEncoder mqttMessageEncoder;
    @NotNull
    private final EventLog eventLog;
    @NotNull
    private final SslParameterHandler sslParameterHandler;
    @NotNull
    private final MqttDecoders mqttDecoders;
    @NotNull
    private final Provider<AuthHandler> authHandlerProvider;
    @NotNull
    private final Provider<PluginInitializerHandler> pluginInitializerHandlerProvider;
    @NotNull
    private final Provider<ClientLifecycleEventHandler> clientLifecycleEventHandlerProvider;
    @NotNull
    private final AuthInProgressMessageHandler authInProgressMessageHandler;
    @NotNull
    private final Provider<IncomingPublishHandler> incomingPublishHandlerProvider;
    @NotNull
    private final Provider<IncomingSubscribeHandler> incomingSubscribeHandlerProvider;
    @NotNull
    private final Provider<MessageExpiryHandler> publishMessageExpiryHandlerProvider;
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;
    @NotNull
    private final InterceptorHandler interceptorHandler;
    @NotNull
    private final GlobalMQTTMessageCounter globalMQTTMessageCounter;
    @NotNull
    private final ShutdownHooks shutdownHooks;

    @Inject
    public ChannelDependencies(@NotNull NoConnectIdleHandler noConnectIdleHandler, @NotNull Provider<ConnectHandler> connectHandlerProvider, @NotNull ConnectionLimiterHandler connectionLimiterHandler, @NotNull DisconnectHandler disconnectHandler, @NotNull Provider<SubscribeHandler> subscribeHandlerProvider, @NotNull UnsubscribeHandler unsubscribeHandler, @NotNull ChannelGroup channelGroup, @NotNull FullConfigurationService fullConfigurationService, @NotNull GlobalTrafficShapingHandler globalTrafficShapingHandler, @NotNull MetricsHolder metricsHolder, @NotNull ExceptionHandler exceptionHandler, @NotNull PingRequestHandler pingRequestHandler, @NotNull RestrictionsConfigurationService restrictionsConfigurationService, @NotNull MqttConnectDecoder mqttConnectDecoder, @NotNull MqttConnacker mqttConnacker, @NotNull EventLog eventLog, @NotNull SslParameterHandler sslParameterHandler, @NotNull MqttDecoders mqttDecoders, @NotNull EncoderFactory encoderFactory, @NotNull Provider<AuthHandler> authHandlerProvider, @NotNull AuthInProgressMessageHandler authInProgressMessageHandler, @NotNull Provider<PluginInitializerHandler> pluginInitializerHandlerProvider, @NotNull Provider<ClientLifecycleEventHandler> clientLifecycleEventHandlerProvider, @NotNull Provider<IncomingPublishHandler> incomingPublishHandlerProvider, @NotNull Provider<IncomingSubscribeHandler> incomingSubscribeHandlerProvider, @NotNull Provider<MessageExpiryHandler> publishMessageExpiryHandlerProvider, @NotNull MqttServerDisconnector mqttServerDisconnector, @NotNull InterceptorHandler interceptorHandler, @NotNull GlobalMQTTMessageCounter globalMQTTMessageCounter, @NotNull ShutdownHooks shutdownHooks) {
        this.noConnectIdleHandler = noConnectIdleHandler;
        this.connectHandlerProvider = connectHandlerProvider;
        this.connectionLimiterHandler = connectionLimiterHandler;
        this.disconnectHandler = disconnectHandler;
        this.subscribeHandlerProvider = subscribeHandlerProvider;
        this.unsubscribeHandler = unsubscribeHandler;
        this.channelGroup = channelGroup;
        this.fullConfigurationService = fullConfigurationService;
        this.globalTrafficShapingHandler = globalTrafficShapingHandler;
        this.metricsHolder = metricsHolder;
        this.exceptionHandler = exceptionHandler;
        this.pingRequestHandler = pingRequestHandler;
        this.restrictionsConfigurationService = restrictionsConfigurationService;
        this.mqttConnectDecoder = mqttConnectDecoder;
        this.mqttConnacker = mqttConnacker;
        this.shutdownHooks = shutdownHooks;
        this.mqttMessageEncoder = new MQTTMessageEncoder(encoderFactory, globalMQTTMessageCounter);
        this.eventLog = eventLog;
        this.sslParameterHandler = sslParameterHandler;
        this.mqttDecoders = mqttDecoders;
        this.authHandlerProvider = authHandlerProvider;
        this.authInProgressMessageHandler = authInProgressMessageHandler;
        this.pluginInitializerHandlerProvider = pluginInitializerHandlerProvider;
        this.clientLifecycleEventHandlerProvider = clientLifecycleEventHandlerProvider;
        this.incomingPublishHandlerProvider = incomingPublishHandlerProvider;
        this.incomingSubscribeHandlerProvider = incomingSubscribeHandlerProvider;
        this.publishMessageExpiryHandlerProvider = publishMessageExpiryHandlerProvider;
        this.mqttServerDisconnector = mqttServerDisconnector;
        this.interceptorHandler = interceptorHandler;
        this.globalMQTTMessageCounter = globalMQTTMessageCounter;
    }

    @NotNull
    public NoConnectIdleHandler getNoConnectIdleHandler() {
        return this.noConnectIdleHandler;
    }

    @NotNull
    public ConnectHandler getConnectHandler() {
        return (ConnectHandler)((Object)this.connectHandlerProvider.get());
    }

    @NotNull
    public ConnectionLimiterHandler getConnectionLimiterHandler() {
        return this.connectionLimiterHandler;
    }

    @NotNull
    public DisconnectHandler getDisconnectHandler() {
        return this.disconnectHandler;
    }

    @NotNull
    public SubscribeHandler getSubscribeHandler() {
        return (SubscribeHandler)((Object)this.subscribeHandlerProvider.get());
    }

    @NotNull
    public UnsubscribeHandler getUnsubscribeHandler() {
        return this.unsubscribeHandler;
    }

    @NotNull
    public ChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    @NotNull
    public FullConfigurationService getConfigurationService() {
        return this.fullConfigurationService;
    }

    @NotNull
    public GlobalTrafficShapingHandler getGlobalTrafficShapingHandler() {
        return this.globalTrafficShapingHandler;
    }

    @NotNull
    public MetricsHolder getMetricsHolder() {
        return this.metricsHolder;
    }

    @NotNull
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @NotNull
    public PingRequestHandler getPingRequestHandler() {
        return this.pingRequestHandler;
    }

    @NotNull
    public RestrictionsConfigurationService getRestrictionsConfigurationService() {
        return this.restrictionsConfigurationService;
    }

    @NotNull
    public MqttConnectDecoder getMqttConnectDecoder() {
        return this.mqttConnectDecoder;
    }

    @NotNull
    public MqttConnacker getMqttConnacker() {
        return this.mqttConnacker;
    }

    @NotNull
    public MQTTMessageEncoder getMqttMessageEncoder() {
        return this.mqttMessageEncoder;
    }

    @NotNull
    public MessageExpiryHandler getPublishMessageExpiryHandler() {
        return (MessageExpiryHandler)((Object)this.publishMessageExpiryHandlerProvider.get());
    }

    @NotNull
    public EventLog getEventLog() {
        return this.eventLog;
    }

    @NotNull
    public SslParameterHandler getSslParameterHandler() {
        return this.sslParameterHandler;
    }

    @NotNull
    public MqttDecoders getMqttDecoders() {
        return this.mqttDecoders;
    }

    @NotNull
    public AuthHandler getAuthHandler() {
        return (AuthHandler)((Object)this.authHandlerProvider.get());
    }

    @NotNull
    public AuthInProgressMessageHandler getAuthInProgressMessageHandler() {
        return this.authInProgressMessageHandler;
    }

    @NotNull
    public PluginInitializerHandler getPluginInitializerHandler() {
        return (PluginInitializerHandler)((Object)this.pluginInitializerHandlerProvider.get());
    }

    @NotNull
    public ClientLifecycleEventHandler getClientLifecycleEventHandler() {
        return (ClientLifecycleEventHandler)((Object)this.clientLifecycleEventHandlerProvider.get());
    }

    @NotNull
    public IncomingPublishHandler getIncomingPublishHandler() {
        return (IncomingPublishHandler)this.incomingPublishHandlerProvider.get();
    }

    @NotNull
    public IncomingSubscribeHandler getIncomingSubscribeHandler() {
        return (IncomingSubscribeHandler)this.incomingSubscribeHandlerProvider.get();
    }

    @NotNull
    public MqttServerDisconnector getMqttServerDisconnector() {
        return this.mqttServerDisconnector;
    }

    @NotNull
    public InterceptorHandler getInterceptorHandler() {
        return this.interceptorHandler;
    }

    @NotNull
    public GlobalMQTTMessageCounter getGlobalMQTTMessageCounter() {
        return this.globalMQTTMessageCounter;
    }

    @NotNull
    public PublishFlushHandler createPublishFlushHandler() {
        return new PublishFlushHandler(this.metricsHolder);
    }

    @NotNull
    public ShutdownHooks getShutdownHooks() {
        return this.shutdownHooks;
    }
}

