/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap.netty;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CorruptedFrameException;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ChannelHandler.Sharable
public class ExceptionHandler
extends ChannelHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandler.class);
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;

    @Inject
    public ExceptionHandler(@NotNull MqttServerDisconnector mqttServerDisconnector) {
        this.mqttServerDisconnector = mqttServerDisconnector;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Channel channel = ctx.channel();
        if (cause instanceof SSLException) {
            return;
        }
        if (cause instanceof ClosedChannelException) {
            return;
        }
        if (cause instanceof IOException) {
            return;
        }
        if (cause instanceof CorruptedFrameException) {
            this.mqttServerDisconnector.disconnect(channel, "A client (IP: {}) sent illegal websocket data. Disconnecting client.", "Illegal websocket data sent by client: " + cause.getMessage(), Mqtt5DisconnectReasonCode.UNSPECIFIED_ERROR, null);
            return;
        }
        if (!(cause instanceof IllegalArgumentException)) {
            ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
            Optional<String> channelIP = clientConnectionContext.getChannelIP();
            log.error("An unexpected error occurred for client with IP {}: {}", (Object)channelIP.orElse("UNKNOWN"), (Object)ExceptionUtils.getStackTrace((Throwable)cause));
        }
        if (channel != null) {
            this.mqttServerDisconnector.disconnect(channel, null, "Channel exception: " + cause.getMessage(), Mqtt5DisconnectReasonCode.UNSPECIFIED_ERROR, null);
        }
    }
}

