/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt3;

import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttDecoder;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.mqtt.message.unsubscribe.UNSUBSCRIBE;
import com.hivemq.util.Strings;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;

@LazySingleton
public class Mqtt3UnsubscribeDecoder
extends AbstractMqttDecoder<UNSUBSCRIBE> {
    @Inject
    public Mqtt3UnsubscribeDecoder(@NotNull MqttServerDisconnector disconnector, @NotNull FullConfigurationService configurationService) {
        super(disconnector, configurationService);
    }

    @Override
    @Nullable
    public UNSUBSCRIBE decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        if (clientConnectionContext.getProtocolVersion() == ProtocolVersion.MQTTv3_1_1) {
            if ((header & 0xF) != 2) {
                this.disconnectByInvalidFixedHeader(clientConnectionContext, MessageType.UNSUBSCRIBE);
                buf.clear();
                return null;
            }
        } else if (clientConnectionContext.getProtocolVersion() == ProtocolVersion.MQTTv3_1 && (header & 0xF) > 3) {
            this.disconnectByInvalidFixedHeader(clientConnectionContext, MessageType.UNSUBSCRIBE);
            buf.clear();
            return null;
        }
        if (buf.readableBytes() < 2) {
            this.disconnectByNoMessageId(clientConnectionContext, MessageType.UNSUBSCRIBE);
            buf.clear();
            return null;
        }
        int messageId = buf.readUnsignedShort();
        ArrayList<String> topics = new ArrayList<String>();
        while (buf.isReadable()) {
            String topic = Strings.getPrefixedString(buf);
            if (Mqtt3UnsubscribeDecoder.isInvalidTopic(clientConnectionContext, topic)) {
                this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent an UNSUBSCRIBE with an invalid topic filter. This is not allowed. Disconnecting client.", "Sent UNSUBSCRIBE with an invalid topic filter", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, "Sent UNSUBSCRIBE with an invalid topic filter.");
                buf.clear();
                return null;
            }
            topics.add(topic);
        }
        if (topics.isEmpty()) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent an UNSUBSCRIBE without topic filters. This is not allowed. Disconnecting client.", "Sent UNSUBSCRIBE without topic filters", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "UNSUBSCRIBE containing no topic filters was sent. This is a protocol violation.");
            buf.clear();
            return null;
        }
        return new UNSUBSCRIBE(topics, messageId);
    }
}

