/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt3;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.codec.encoder.MqttEncoder;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.pubrec.PUBREC;
import io.netty.buffer.ByteBuf;

public class Mqtt3PubrecEncoder
implements MqttEncoder<PUBREC> {
    public static final int ENCODED_PUBREC_SIZE = 4;
    private static final byte PUBREC_FIXED_HEADER = 80;
    private static final byte PUBREC_REMAINING_LENGTH = 2;

    @Override
    public void encode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull PUBREC msg, @NotNull ByteBuf out) {
        if (msg.getPacketIdentifier() == 0) {
            throw new IllegalArgumentException("Message ID must not be null");
        }
        out.writeByte(80);
        out.writeByte(2);
        out.writeShort(msg.getPacketIdentifier());
    }

    @Override
    public int bufferSize(@NotNull ClientConnectionContext clientConnectionContext, @NotNull PUBREC msg) {
        return 4;
    }
}

