/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt5;

import com.google.common.base.Charsets;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.codec.encoder.mqtt5.MqttBinaryData;
import com.hivemq.codec.encoder.mqtt5.MqttVariableByteInteger;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.QoS;
import io.netty.buffer.ByteBuf;

final class Mqtt5MessageEncoderUtil {
    private Mqtt5MessageEncoderUtil() {
    }

    static int propertyEncodedLength(@NotNull String value) {
        return 1 + MqttBinaryData.encodedLength(value);
    }

    static int nullablePropertyEncodedLength(@Nullable String value) {
        return value == null ? 0 : Mqtt5MessageEncoderUtil.propertyEncodedLength(value);
    }

    static int nullablePropertyEncodedLength(byte @Nullable [] binary) {
        return binary == null ? 0 : 1 + MqttBinaryData.encodedLength(binary);
    }

    static int nullablePropertyEncodedLength(@Nullable Mqtt5PayloadFormatIndicator payloadFormatIndicator) {
        return payloadFormatIndicator == null ? 0 : 2;
    }

    static int nullablePropertyEncodedLength(@Nullable QoS qoS) {
        return qoS != null && qoS != QoS.EXACTLY_ONCE ? 2 : 0;
    }

    static int booleanPropertyEncodedLength(boolean value, boolean defaultValue) {
        return value == defaultValue ? 0 : 2;
    }

    static int shortPropertyEncodedLength(int value, int defaultValue) {
        return value == defaultValue ? 0 : 3;
    }

    static int intPropertyEncodedLength(long value, long defaultValue) {
        return value == defaultValue ? 0 : 5;
    }

    static int variableByteIntegerPropertyEncodedLength(int value) {
        return 1 + MqttVariableByteInteger.encodedLength(value);
    }

    static void encodeProperty(int propertyIdentifier, @NotNull String value, @NotNull ByteBuf out) {
        out.writeByte(propertyIdentifier);
        MqttBinaryData.encode(value.getBytes(Charsets.UTF_8), out);
    }

    static void encodeNullableProperty(int propertyIdentifier, @Nullable String value, @NotNull ByteBuf out) {
        if (value != null) {
            Mqtt5MessageEncoderUtil.encodeProperty(propertyIdentifier, value, out);
        }
    }

    static void encodeNullableProperty(int propertyIdentifier, byte @Nullable [] binary, @NotNull ByteBuf out) {
        if (binary != null) {
            out.writeByte(propertyIdentifier);
            MqttBinaryData.encode(binary, out);
        }
    }

    static void encodeNullableProperty(int propertyIdentifier, @Nullable QoS qoS, @NotNull ByteBuf out) {
        if (qoS != null && qoS.getQosNumber() < 2) {
            out.writeByte(propertyIdentifier);
            out.writeByte(qoS.getQosNumber());
        }
    }

    static void encodeNullableProperty(int propertyIdentifier, @Nullable Mqtt5PayloadFormatIndicator payloadFormatIndicator, @NotNull ByteBuf out) {
        if (payloadFormatIndicator != null) {
            out.writeByte(propertyIdentifier);
            out.writeByte(payloadFormatIndicator.getCode());
        }
    }

    static void encodeBooleanProperty(int propertyIdentifier, boolean value, boolean defaultValue, @NotNull ByteBuf out) {
        if (value != defaultValue) {
            out.writeByte(propertyIdentifier);
            out.writeByte(value ? 1 : 0);
        }
    }

    static void encodeShortProperty(int propertyIdentifier, int value, int defaultValue, @NotNull ByteBuf out) {
        if (value != defaultValue) {
            out.writeByte(propertyIdentifier);
            out.writeShort(value);
        }
    }

    static void encodeIntProperty(int propertyIdentifier, long value, long defaultValue, @NotNull ByteBuf out) {
        if (value != defaultValue) {
            out.writeByte(propertyIdentifier);
            out.writeInt((int)value);
        }
    }

    static void encodeVariableByteIntegerProperty(int propertyIdentifier, int value, @NotNull ByteBuf out) {
        out.writeByte(propertyIdentifier);
        MqttVariableByteInteger.encode(value, out);
    }
}

