/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt5;

import com.google.common.base.Preconditions;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.codec.encoder.MqttEncoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5MessageEncoderUtil;
import com.hivemq.codec.encoder.mqtt5.MqttMessageEncoderUtil;
import com.hivemq.codec.encoder.mqtt5.MqttVariableByteInteger;
import com.hivemq.configuration.service.SecurityConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.event.PublishDroppedEvent;
import com.hivemq.mqtt.message.Message;
import com.hivemq.mqtt.message.connack.CONNACK;
import com.hivemq.mqtt.message.disconnect.DISCONNECT;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttMessageWithUserProperties;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.reason.Mqtt5ReasonCode;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.EncoderException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Mqtt5MessageWithUserPropertiesEncoder<T extends Message>
implements MqttEncoder<T> {
    private static final Logger log = LoggerFactory.getLogger(Mqtt5MessageWithUserPropertiesEncoder.class);
    @NotNull
    private final MessageDroppedService messageDroppedService;
    @NotNull
    private final SecurityConfigurationService securityConfigurationService;

    Mqtt5MessageWithUserPropertiesEncoder(@NotNull MessageDroppedService messageDroppedService, @NotNull SecurityConfigurationService securityConfigurationService) {
        this.messageDroppedService = messageDroppedService;
        this.securityConfigurationService = securityConfigurationService;
    }

    @Override
    public void encode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull T msg, @NotNull ByteBuf out) {
        Preconditions.checkNotNull((Object)clientConnectionContext, (Object)"ClientContext must never be null");
        Preconditions.checkNotNull(msg, (Object)"Message must never be null");
        Preconditions.checkNotNull((Object)out, (Object)"ByteBuf must never be null");
        if (msg.getOmittedProperties() > 0) {
            String clientIdFromChannel = clientConnectionContext.getClientId();
            String clientId = clientIdFromChannel != null ? clientIdFromChannel : "UNKNOWN";
            long maximumPacketSize = Mqtt5MessageWithUserPropertiesEncoder.calculateMaxMessageSize(clientConnectionContext);
            if (msg instanceof PUBLISH) {
                clientConnectionContext.getChannel().pipeline().fireUserEventTriggered((Object)new PublishDroppedEvent((PUBLISH)msg));
                this.messageDroppedService.publishMaxPacketSizeExceeded(clientId, ((PUBLISH)msg).getTopic(), ((PUBLISH)msg).getQoS().getQosNumber(), maximumPacketSize, msg.getEncodedLength());
                if (log.isTraceEnabled()) {
                    log.trace("Could not encode publish message for client ({}): Maximum packet size limit exceeded", (Object)clientId);
                }
                return;
            }
            if (msg.getPropertyLength() < 0 && (long)msg.getEncodedLength() > maximumPacketSize) {
                this.messageDroppedService.messageMaxPacketSizeExceeded(clientId, msg.getType().name(), maximumPacketSize, msg.getEncodedLength());
                if (log.isTraceEnabled()) {
                    log.trace("Could not encode message of type {} for client {}: Packet too large", (Object)msg.getType(), (Object)clientId);
                }
                throw new EncoderException("Maximum packet size exceeded");
            }
        }
        this.encode(msg, out);
    }

    @Override
    public int bufferSize(@NotNull ClientConnectionContext clientConnectionContext, @NotNull T msg) {
        int omittedProperties = 0;
        int propertyLength = this.calculatePropertyLength(msg);
        if (!this.securityConfigurationService.allowRequestProblemInformation() || !Objects.requireNonNullElse(clientConnectionContext.getRequestProblemInformation(), true).booleanValue()) {
            boolean mustOmit;
            boolean bl = mustOmit = !(msg instanceof PUBLISH) && !(msg instanceof CONNACK) && !(msg instanceof DISCONNECT);
            if (mustOmit) {
                propertyLength = this.propertyLength(msg, propertyLength, ++omittedProperties);
                propertyLength = this.propertyLength(msg, propertyLength, ++omittedProperties);
            }
        }
        long maximumPacketSize = Mqtt5MessageWithUserPropertiesEncoder.calculateMaxMessageSize(clientConnectionContext);
        int remainingLengthWithoutProperties = this.calculateRemainingLengthWithoutProperties(msg);
        int remainingLength = this.remainingLength(msg, remainingLengthWithoutProperties, propertyLength);
        int encodedLength = MqttMessageEncoderUtil.encodedPacketLength(remainingLength);
        while ((long)encodedLength > maximumPacketSize && (propertyLength = this.propertyLength(msg, propertyLength, ++omittedProperties)) != -1) {
            remainingLength = this.remainingLength(msg, remainingLengthWithoutProperties, propertyLength);
            encodedLength = MqttMessageEncoderUtil.encodedPacketLength(remainingLength);
        }
        msg.setEncodedLength(encodedLength);
        msg.setOmittedProperties(omittedProperties);
        msg.setRemainingLength(remainingLength);
        msg.setPropertyLength(propertyLength);
        return encodedLength;
    }

    private static long calculateMaxMessageSize(@NotNull ClientConnectionContext clientConnectionContext) {
        Preconditions.checkNotNull((Object)clientConnectionContext, (Object)"ClientContext must never be null");
        Long maxMessageSize = clientConnectionContext.getMaxPacketSizeSend();
        return Objects.requireNonNullElse(maxMessageSize, 0x10000004L);
    }

    abstract void encode(@NotNull T var1, @NotNull ByteBuf var2);

    public int remainingLength(@NotNull T message, int remainingLengthWithoutProperties, int propertyLength) {
        return remainingLengthWithoutProperties + this.encodedPropertyLengthWithHeader(message, propertyLength);
    }

    abstract int calculateRemainingLengthWithoutProperties(@NotNull T var1);

    abstract int calculatePropertyLength(@NotNull T var1);

    int propertyLength(@NotNull T message, int propertyLength, int omittedProperties) {
        switch (omittedProperties) {
            case 0: {
                return propertyLength;
            }
            case 1: {
                return propertyLength - this.getUserProperties(message).encodedLength();
            }
        }
        return -1;
    }

    int encodedPropertyLengthWithHeader(@NotNull T message, int propertyLength) {
        return MqttMessageEncoderUtil.encodedLengthWithHeader(propertyLength);
    }

    int omissiblePropertiesLength(@NotNull T message) {
        return this.getUserProperties(message).encodedLength();
    }

    void encodeOmissibleProperties(@NotNull T message, @NotNull ByteBuf out) {
        if (message.getOmittedProperties() == 0) {
            this.getUserProperties(message).encode(out);
        }
    }

    @NotNull
    abstract Mqtt5UserProperties getUserProperties(@NotNull T var1);

    static abstract class Mqtt5MessageWithIdAndOmissibleReasonCodeEncoder<M extends MqttMessageWithUserProperties.MqttMessageWithIdAndReasonCode<R>, R extends Mqtt5ReasonCode>
    extends Mqtt5MessageWithOmissibleReasonCodeEncoder<M, R> {
        Mqtt5MessageWithIdAndOmissibleReasonCodeEncoder(@NotNull MessageDroppedService messageDroppedService, @NotNull SecurityConfigurationService securityConfigurationService) {
            super(messageDroppedService, securityConfigurationService);
        }

        @Override
        int additionalRemainingLength(@NotNull M message) {
            return 2;
        }

        @Override
        void encodeAdditionalVariableHeader(@NotNull M message, @NotNull ByteBuf out) {
            out.writeShort(((MqttMessageWithUserProperties.MqttMessageWithIdAndReasonCode)message).getPacketIdentifier());
        }
    }

    static abstract class Mqtt5MessageWithOmissibleReasonCodeEncoder<M extends MqttMessageWithUserProperties.MqttMessageWithReasonCode<R>, R extends Mqtt5ReasonCode>
    extends Mqtt5MessageWithReasonStringEncoder<M> {
        Mqtt5MessageWithOmissibleReasonCodeEncoder(@NotNull MessageDroppedService messageDroppedService, @NotNull SecurityConfigurationService securityConfigurationService) {
            super(messageDroppedService, securityConfigurationService);
        }

        abstract int getFixedHeader();

        @NotNull
        abstract R getDefaultReasonCode();

        @Override
        final int calculateRemainingLengthWithoutProperties(@NotNull M message) {
            return 1 + this.additionalRemainingLength(message);
        }

        int additionalRemainingLength(@NotNull M message) {
            return 0;
        }

        @Override
        final int calculatePropertyLength(@NotNull M message) {
            return this.omissiblePropertiesLength(message) + this.additionalPropertyLength(message);
        }

        int additionalPropertyLength(@NotNull M message) {
            return 0;
        }

        @Override
        void encode(@NotNull M message, @NotNull ByteBuf out) {
            this.encodeFixedHeader(out, ((MqttMessageWithUserProperties)message).getRemainingLength());
            this.encodeVariableHeader(message, out);
        }

        private void encodeFixedHeader(@NotNull ByteBuf out, int remainingLength) {
            out.writeByte(this.getFixedHeader());
            MqttVariableByteInteger.encode(remainingLength, out);
        }

        private void encodeVariableHeader(@NotNull M message, @NotNull ByteBuf out) {
            this.encodeAdditionalVariableHeader(message, out);
            Object reasonCode = ((MqttMessageWithUserProperties.MqttMessageWithReasonCode)message).getReasonCode();
            if (((MqttMessageWithUserProperties)message).getPropertyLength() == 0) {
                if (reasonCode != this.getDefaultReasonCode()) {
                    out.writeByte(reasonCode.getCode());
                }
            } else {
                out.writeByte(reasonCode.getCode());
                MqttVariableByteInteger.encode(((MqttMessageWithUserProperties)message).getPropertyLength(), out);
                this.encodeAdditionalProperties(message, out);
                this.encodeOmissibleProperties(message, out);
            }
        }

        void encodeAdditionalVariableHeader(@NotNull M message, @NotNull ByteBuf out) {
        }

        void encodeAdditionalProperties(@NotNull M message, @NotNull ByteBuf out) {
        }

        @Override
        final int encodedPropertyLengthWithHeader(@NotNull M message, int propertyLength) {
            if (propertyLength == 0) {
                return ((MqttMessageWithUserProperties.MqttMessageWithReasonCode)message).getReasonCode() == this.getDefaultReasonCode() ? -1 : 0;
            }
            return super.encodedPropertyLengthWithHeader(message, propertyLength);
        }
    }

    static abstract class Mqtt5MessageWithReasonStringEncoder<M extends MqttMessageWithUserProperties.MqttMessageWithReasonString>
    extends Mqtt5MessageWithUserPropertiesEncoder<M> {
        Mqtt5MessageWithReasonStringEncoder(@NotNull MessageDroppedService messageDroppedService, @NotNull SecurityConfigurationService securityConfigurationService) {
            super(messageDroppedService, securityConfigurationService);
        }

        @Override
        int propertyLength(@NotNull M message, int propertyLength, int omittedProperties) {
            switch (omittedProperties) {
                case 0: {
                    return propertyLength;
                }
                case 1: {
                    return propertyLength - this.reasonStringLength(message);
                }
                case 2: {
                    return propertyLength - this.getUserProperties(message).encodedLength();
                }
            }
            return -1;
        }

        @Override
        final int omissiblePropertiesLength(@NotNull M message) {
            return this.reasonStringLength(message) + this.getUserProperties(message).encodedLength();
        }

        @Override
        void encodeOmissibleProperties(@NotNull M message, @NotNull ByteBuf out) {
            if (((MqttMessageWithUserProperties)message).getOmittedProperties() == 0) {
                Mqtt5MessageEncoderUtil.encodeNullableProperty(31, ((MqttMessageWithUserProperties.MqttMessageWithReasonString)message).getReasonString(), out);
            }
            if (((MqttMessageWithUserProperties)message).getOmittedProperties() <= 1) {
                this.getUserProperties(message).encode(out);
            }
        }

        private int reasonStringLength(@NotNull M message) {
            return Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(((MqttMessageWithUserProperties.MqttMessageWithReasonString)message).getReasonString());
        }

        @Override
        @NotNull
        Mqtt5UserProperties getUserProperties(@NotNull M message) {
            return ((MqttMessageWithUserProperties)message).getUserProperties();
        }
    }
}

