/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration;

import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.configuration.ioc.ConfigurationFileProvider;
import com.hivemq.configuration.reader.ConfigFileReader;
import com.hivemq.configuration.reader.ConfigurationFile;
import com.hivemq.configuration.reader.ListenerConfigurator;
import com.hivemq.configuration.reader.MqttConfigurator;
import com.hivemq.configuration.reader.PersistenceConfigurator;
import com.hivemq.configuration.reader.RestrictionConfigurator;
import com.hivemq.configuration.reader.SecurityConfigurator;
import com.hivemq.configuration.reader.UsageStatisticsConfigurator;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.configuration.service.impl.ConfigurationServiceImpl;
import com.hivemq.configuration.service.impl.MqttConfigurationServiceImpl;
import com.hivemq.configuration.service.impl.PersistenceConfigurationServiceImpl;
import com.hivemq.configuration.service.impl.RestrictionsConfigurationServiceImpl;
import com.hivemq.configuration.service.impl.SecurityConfigurationServiceImpl;
import com.hivemq.configuration.service.impl.listener.ListenerConfigurationServiceImpl;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.statistics.UsageStatisticsConfigImpl;
import com.hivemq.util.EnvVarUtil;

public class ConfigurationBootstrap {
    @NotNull
    public static FullConfigurationService bootstrapConfig(@NotNull SystemInformation systemInformation) {
        ConfigurationServiceImpl configurationService = new ConfigurationServiceImpl(new ListenerConfigurationServiceImpl(), new MqttConfigurationServiceImpl(), new RestrictionsConfigurationServiceImpl(), new SecurityConfigurationServiceImpl(), new UsageStatisticsConfigImpl(), new PersistenceConfigurationServiceImpl());
        ConfigurationFile configurationFile = ConfigurationFileProvider.get(systemInformation);
        ConfigFileReader configFileReader = new ConfigFileReader(configurationFile, new RestrictionConfigurator(configurationService.restrictionsConfiguration()), new SecurityConfigurator(configurationService.securityConfiguration()), new EnvVarUtil(), new UsageStatisticsConfigurator(configurationService.usageStatisticsConfiguration()), new MqttConfigurator(configurationService.mqttConfiguration()), new ListenerConfigurator(configurationService.listenerConfiguration(), systemInformation), new PersistenceConfigurator(configurationService.persistenceConfigurationService()));
        configFileReader.applyConfig();
        return configurationService;
    }
}

