/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.service.impl.listener;

import com.google.common.collect.ImmutableList;
import com.hivemq.configuration.service.entity.Listener;
import com.hivemq.configuration.service.entity.TcpListener;
import com.hivemq.configuration.service.entity.TlsTcpListener;
import com.hivemq.configuration.service.entity.TlsWebsocketListener;
import com.hivemq.configuration.service.entity.WebsocketListener;
import com.hivemq.configuration.service.impl.listener.ListenerConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ListenerConfigurationServiceImpl
implements ListenerConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(ListenerConfigurationServiceImpl.class);
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    @Override
    public <T extends Listener> void addListener(@NotNull T listener) {
        if (!(listener.getClass().equals(TcpListener.class) || listener.getClass().equals(TlsTcpListener.class) || listener.getClass().equals(WebsocketListener.class) || listener.getClass().equals(TlsWebsocketListener.class))) {
            throw new IllegalArgumentException(listener.getClass().getName() + " is not a valid listener type");
        }
        log.debug("Adding {} on bind address {} and port {}. Name: {}.", new Object[]{listener.readableName(), listener.getBindAddress(), listener.getPort(), listener.getName()});
        this.listeners.add(listener);
        ImmutableList allListeners = ImmutableList.copyOf(this.listeners);
        log.trace("Notifying {} update listeners for changes", (Object)allListeners.size());
    }

    @NotNull
    public ImmutableList<Listener> getListeners() {
        return ImmutableList.copyOf(this.listeners);
    }

    @NotNull
    public ImmutableList<TcpListener> getTcpListeners() {
        return this.filterListeners(TcpListener.class);
    }

    @NotNull
    public ImmutableList<TlsTcpListener> getTlsTcpListeners() {
        return this.filterListeners(TlsTcpListener.class);
    }

    @NotNull
    public ImmutableList<WebsocketListener> getWebsocketListeners() {
        return this.filterListeners(WebsocketListener.class);
    }

    @NotNull
    public ImmutableList<TlsWebsocketListener> getTlsWebsocketListeners() {
        return this.filterListeners(TlsWebsocketListener.class);
    }

    public void clear() {
        this.listeners.clear();
    }

    @NotNull
    private <T extends Listener> ImmutableList<T> filterListeners(@NotNull Class<T> clazz) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Listener listener : this.listeners) {
            if (!listener.getClass().equals(clazz)) continue;
            builder.add((Object)((Listener)clazz.cast(listener)));
        }
        return builder.build();
    }
}

