/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.diagnostic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DiagnosticLogging {
    private static final Logger log = LoggerFactory.getLogger(DiagnosticLogging.class);

    DiagnosticLogging() {
    }

    static void setTraceLog(String filePath) {
        log.info("Creating trace log {}", (Object)filePath);
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        Level originalLoggingLevel = logger.getLevel();
        Iterator appenderIterator = logger.iteratorForAppenders();
        while (appenderIterator.hasNext()) {
            Appender next = (Appender)appenderIterator.next();
            next.addFilter((Filter)new PreserveOriginalLoggingLevelFilter(originalLoggingLevel));
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern("%date %level [%thread] %logger{10} [%file:%line] %msg%n");
        ple.setContext((Context)lc);
        ple.start();
        FileAppender fileAppender = new FileAppender();
        fileAppender.setFile(filePath);
        fileAppender.setEncoder((Encoder)ple);
        fileAppender.setContext((Context)lc);
        fileAppender.start();
        logger.addAppender((Appender)fileAppender);
        logger.setLevel(Level.ALL);
        logger.setAdditive(false);
    }

    private static class PreserveOriginalLoggingLevelFilter
    extends Filter<ILoggingEvent> {
        private final Level originalLevel;

        PreserveOriginalLoggingLevelFilter(Level originalLevel) {
            this.originalLevel = originalLevel;
        }

        public FilterReply decide(ILoggingEvent event) {
            if (event.getLevel().toInt() < this.originalLevel.toInt()) {
                return FilterReply.DENY;
            }
            return FilterReply.ACCEPT;
        }
    }
}

