/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.diagnostic;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.diagnostic.DiagnosticLogging;
import com.hivemq.diagnostic.data.DiagnosticData;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.util.ThreadFactoryUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DiagnosticMode {
    private static final Logger log = LoggerFactory.getLogger(DiagnosticMode.class);
    private static final String THREAD_NAME_FORMAT = "diagnostic-mode-%d";
    public static final String FILE_NAME_METRIC_LOG = "metric.log";
    public static final String FILE_NAME_TRACE_LOG = "tracelog.log";
    public static final String FILE_NAME_DIAGNOSTICS_FILE = "diagnostics.txt";
    public static final String FILE_NAME_DIAGNOSTICS_FOLDER = "diagnostics";
    public static final String FILE_NAME_MIGRATION_LOG = "migration.log";
    @NotNull
    private final DiagnosticData diagnosticData;
    @NotNull
    private final SystemInformation systemInformation;
    @NotNull
    private final MetricRegistry metricRegistry;
    @NotNull
    private final ShutdownHooks shutdownHooks;
    @NotNull
    private final ScheduledExecutorService executor;
    @Nullable
    private ConsoleReporter metricReporter;

    @Inject
    DiagnosticMode(@NotNull DiagnosticData diagnosticData, @NotNull SystemInformation systemInformation, @NotNull MetricRegistry metricRegistry, @NotNull ShutdownHooks shutdownHooks) {
        this(diagnosticData, systemInformation, metricRegistry, shutdownHooks, Executors.newSingleThreadScheduledExecutor(ThreadFactoryUtil.create(THREAD_NAME_FORMAT)));
    }

    @VisibleForTesting
    DiagnosticMode(@NotNull DiagnosticData diagnosticData, @NotNull SystemInformation systemInformation, @NotNull MetricRegistry metricRegistry, @NotNull ShutdownHooks shutdownHooks, @NotNull ScheduledExecutorService executor) {
        this.diagnosticData = diagnosticData;
        this.systemInformation = systemInformation;
        this.metricRegistry = metricRegistry;
        this.shutdownHooks = shutdownHooks;
        this.executor = executor;
    }

    @PostConstruct
    public void init() {
        Optional<File> diagnosticsFolder = this.createDiagnosticsFolder();
        if (diagnosticsFolder.isPresent()) {
            this.createDiagnosticsFile(diagnosticsFolder.get());
            DiagnosticLogging.setTraceLog(new File(diagnosticsFolder.get(), FILE_NAME_TRACE_LOG).getAbsolutePath());
            this.copyMigrationLog(diagnosticsFolder);
            this.startLoggingMetrics(diagnosticsFolder.get());
        }
    }

    private void startLoggingMetrics(File diagnosticFolder) {
        File metricLog = new File(diagnosticFolder, FILE_NAME_METRIC_LOG);
        try {
            PrintStream logStream = new PrintStream(metricLog, Charset.defaultCharset().name());
            this.metricReporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).scheduleOn(this.executor).shutdownExecutorOnStop(true).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).outputTo(logStream).build();
            this.metricReporter.start(1L, TimeUnit.SECONDS);
            this.shutdownHooks.add(new HiveMQShutdownHook(){

                @Override
                @NotNull
                public String name() {
                    return "HiveMQ Diagnostic Mode Shutdown";
                }

                @Override
                @NotNull
                public HiveMQShutdownHook.Priority priority() {
                    return HiveMQShutdownHook.Priority.FIRST;
                }

                @Override
                public void run() {
                    DiagnosticMode.this.metricReporter.stop();
                }
            });
        }
        catch (IOException e) {
            log.error("Not able to create metric.log, for {}", e.getCause());
        }
    }

    private void copyMigrationLog(@NotNull Optional<File> diagnosticsFolder) {
        File migrationLog = new File(this.systemInformation.getLogFolder(), FILE_NAME_MIGRATION_LOG);
        if (migrationLog.exists()) {
            try {
                FileUtils.copyFileToDirectory((File)migrationLog, (File)diagnosticsFolder.get());
            }
            catch (IOException e) {
                log.error("Not able to copy migration log to diagnostics folder", (Throwable)e);
            }
        }
    }

    private void createDiagnosticsFile(@NotNull File diagnosticsFolder) {
        File diagnosticsFile = new File(diagnosticsFolder, FILE_NAME_DIAGNOSTICS_FILE);
        try {
            log.info("Creating Diagnostics file: {}", (Object)diagnosticsFile.getAbsolutePath());
            diagnosticsFile.createNewFile();
            Files.write((CharSequence)this.diagnosticData.get(), (File)diagnosticsFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Could not create the diagnostics.txt file. Stopping Diagnostic Mode");
        }
    }

    @NotNull
    private Optional<File> createDiagnosticsFolder() {
        File hiveMQHomeFolder = this.systemInformation.getHiveMQHomeFolder();
        File diagnosticsFolder = new File(hiveMQHomeFolder, FILE_NAME_DIAGNOSTICS_FOLDER);
        if (diagnosticsFolder.exists()) {
            try {
                log.warn("Diagnostics folder already exists, deleting old folder");
                FileUtils.forceDelete((File)diagnosticsFolder);
            }
            catch (IOException e) {
                log.error("Could not delete diagnostics folder. Stopping Diagnostic Mode");
                return Optional.empty();
            }
        }
        try {
            log.info("Creating 'diagnostics' folder in HiveMQ home folder: {}", (Object)hiveMQHomeFolder.getAbsolutePath());
            FileUtils.forceMkdir((File)diagnosticsFolder);
        }
        catch (IOException e) {
            log.error("Could not create diagnostics folder. Stopping Diagnostic Mode");
            return Optional.empty();
        }
        return Optional.of(diagnosticsFolder);
    }
}

