/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.extension.sdk.api.client.parameter.ServerInformation;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.parameter.ExtensionStartOutputImpl;
import com.hivemq.extensions.parameter.ExtensionStartStopInputImpl;
import com.hivemq.extensions.parameter.ExtensionStopOutputImpl;
import com.hivemq.util.Checkpoints;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ThreadSafe
public class HiveMQExtensions {
    private static final Logger log = LoggerFactory.getLogger(HiveMQExtensions.class);
    @NotNull
    private final HashMap<String, HiveMQExtension> knownExtensions = new HashMap();
    @NotNull
    private final HashMap<ClassLoader, HiveMQExtension> classloaderToExtension = new HashMap();
    @NotNull
    private final List<Consumer<HiveMQExtension>> beforeExtensionStopCallbacks = new LinkedList<Consumer<HiveMQExtension>>();
    @NotNull
    private final List<Consumer<HiveMQExtension>> afterExtensionStopCallbacks = new LinkedList<Consumer<HiveMQExtension>>();
    @NotNull
    private final ReadWriteLock extensionsLock = new ReentrantReadWriteLock();
    @NotNull
    private final ReadWriteLock classloaderLock = new ReentrantReadWriteLock();
    @NotNull
    private final ReadWriteLock beforeExtensionStopCallbacksLock = new ReentrantReadWriteLock();
    @NotNull
    private final ReadWriteLock afterExtensionStopCallbacksLock = new ReentrantReadWriteLock();
    @NotNull
    private final ServerInformation serverInformation;

    @Inject
    public HiveMQExtensions(@NotNull ServerInformation serverInformation) {
        this.serverInformation = serverInformation;
    }

    @NotNull
    public Map<String, HiveMQExtension> getEnabledHiveMQExtensions() {
        Lock lock = this.extensionsLock.readLock();
        try {
            lock.lock();
            Map map = (Map)this.knownExtensions.values().stream().filter(HiveMQExtension::isEnabled).sorted(Comparator.comparingInt(HiveMQExtension::getPriority)).collect(ImmutableMap.toImmutableMap(HiveMQExtension::getId, Function.identity()));
            return map;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public ImmutableMap<ClassLoader, HiveMQExtension> getClassloaderToExtensionMap() {
        return ImmutableMap.copyOf(this.classloaderToExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHiveMQExtension(@NotNull HiveMQExtension extension) {
        Preconditions.checkNotNull((Object)extension, (Object)"can only add valid extensions");
        Lock lock = this.extensionsLock.writeLock();
        try {
            lock.lock();
            HiveMQExtension oldExtension = this.knownExtensions.get(extension.getId());
            if (oldExtension != null) {
                extension.setPreviousVersion(oldExtension.getVersion());
            }
            this.knownExtensions.put(extension.getId(), extension);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHiveMQExtensionIDKnown(@NotNull String hiveMQExtensionID) {
        Preconditions.checkNotNull((Object)hiveMQExtensionID, (Object)"every extension must have an id");
        Lock lock = this.extensionsLock.readLock();
        try {
            lock.lock();
            boolean bl = this.knownExtensions.containsKey(hiveMQExtensionID);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isHiveMQExtensionKnown(@NotNull String hiveMQExtensionID, @NotNull Path extensionFolder, boolean enabled) {
        Preconditions.checkNotNull((Object)hiveMQExtensionID, (Object)"every extension must have an id");
        HiveMQExtension extension = this.getExtension(hiveMQExtensionID, enabled);
        return extension != null && extension.getExtensionFolderPath().equals(extensionFolder);
    }

    public boolean isHiveMQExtensionEnabled(@NotNull String hiveMQExtensionID) {
        Preconditions.checkNotNull((Object)hiveMQExtensionID, (Object)"every extension must have an id");
        return this.getExtension(hiveMQExtensionID, true) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public HiveMQExtension getExtension(@NotNull String xtensionId, boolean enabled) {
        Lock lock = this.extensionsLock.readLock();
        try {
            lock.lock();
            HiveMQExtension extension = this.knownExtensions.get(xtensionId);
            HiveMQExtension hiveMQExtension = extension == null || extension.isEnabled() != enabled ? null : extension;
            return hiveMQExtension;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public HiveMQExtension getExtension(@NotNull String extensionId) {
        Lock lock = this.extensionsLock.readLock();
        try {
            lock.lock();
            HiveMQExtension hiveMQExtension = this.knownExtensions.get(extensionId);
            return hiveMQExtension;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public HiveMQExtension getExtensionForClassloader(@NotNull ClassLoader classloader) {
        Lock lock = this.classloaderLock.readLock();
        try {
            lock.lock();
            HiveMQExtension hiveMQExtension = this.classloaderToExtension.get(classloader);
            return hiveMQExtension;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClassLoaderMapping(@NotNull ClassLoader classloader, @NotNull HiveMQExtension extension) {
        Lock loaderLock = this.classloaderLock.writeLock();
        try {
            loaderLock.lock();
            if (extension.isEmbedded() && extension.getExtensionMainClazz() != null) {
                this.classloaderToExtension.put(extension.getExtensionMainClazz().getClassLoader(), extension);
            }
            this.classloaderToExtension.put(classloader, extension);
        }
        finally {
            loaderLock.unlock();
        }
    }

    private void removeClassLoaderMapping(@NotNull ClassLoader classloader) {
        Lock loaderLock = this.classloaderLock.writeLock();
        try {
            loaderLock.lock();
            this.classloaderToExtension.remove(classloader);
        }
        finally {
            loaderLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extensionStart(@NotNull String extensionId) {
        Preconditions.checkNotNull((Object)extensionId, (Object)"every extension must have an id");
        HiveMQExtension extension = this.getExtension(extensionId, true);
        if (extension == null) {
            return false;
        }
        ClassLoader extensionClassloader = extension.getExtensionClassloader();
        Preconditions.checkNotNull((Object)extensionClassloader, (Object)"Extension ClassLoader cannot be null");
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.addClassLoaderMapping(extensionClassloader, extension);
            ExtensionStartStopInputImpl input = new ExtensionStartStopInputImpl(extension, this.getEnabledHiveMQExtensions(), this.serverInformation);
            ExtensionStartOutputImpl output = new ExtensionStartOutputImpl();
            Thread.currentThread().setContextClassLoader(extensionClassloader);
            extension.start(input, output);
            if (output.getReason().isPresent()) {
                log.info("Startup of {}extension with id \"{}\" was prevented by the extension itself, reason: {}. Extension will be disabled.", new Object[]{extension.isEmbedded() ? "embedded " : "", extension.getId(), output.getReason().get()});
                this.extensionStartFailed(extension, extensionClassloader);
            } else {
                log.info("{}xtension \"{}\" version {} started successfully.", new Object[]{extension.isEmbedded() ? "Embedded e" : "E", extension.getName(), extension.getVersion()});
                Checkpoints.checkpoint("extension-started");
            }
        }
        catch (Throwable t) {
            log.error("{}xtension with id \"{}\" cannot be started because of an uncaught exception thrown by the extension. Extension will be disabled.", new Object[]{extension.isEmbedded() ? "Embedded e" : "E", extension.getId(), t});
            this.extensionStartFailed(extension, extensionClassloader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
        return true;
    }

    private void extensionStartFailed(@NotNull HiveMQExtension extension, @NotNull ClassLoader extensionClassloader) {
        extension.setDisabled();
        extension.clean(true);
        this.removeClassLoaderMapping(extensionClassloader);
        Checkpoints.checkpoint("extension-failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extensionStop(@NotNull String extensionId, boolean disable) {
        HiveMQExtension extension;
        Preconditions.checkNotNull((Object)extensionId, (Object)"every extension must have an id");
        Lock lock = this.extensionsLock.readLock();
        try {
            lock.lock();
            extension = this.knownExtensions.get(extensionId);
            if (extension == null || !extension.isEnabled()) {
                boolean bl = false;
                return bl;
            }
            extension.setDisabled();
        }
        finally {
            lock.unlock();
        }
        ClassLoader extensionClassloader = extension.getExtensionClassloader();
        Preconditions.checkNotNull((Object)extensionClassloader, (Object)"Extension ClassLoader cannot be null");
        this.notifyBeforeExtensionStopCallbacks(extension);
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ExtensionStartStopInputImpl input = new ExtensionStartStopInputImpl(extension, this.getEnabledHiveMQExtensions(), this.serverInformation);
            ExtensionStopOutputImpl output = new ExtensionStopOutputImpl();
            Thread.currentThread().setContextClassLoader(extensionClassloader);
            extension.stop(input, output);
            log.info("{}xtension \"{}\" version {} stopped successfully.", new Object[]{extension.isEmbedded() ? "Embedded e" : "E", extension.getName(), extension.getVersion()});
        }
        catch (Throwable t) {
            log.warn("Uncaught exception was thrown from extension with id \"" + extension.getId() + "\" on extension stop. Extensions are responsible on their own to handle exceptions.", t);
            disable = true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
            this.notifyAfterExtensionStopCallbacks(extension);
            extension.clean(disable);
            this.removeClassLoaderMapping(extensionClassloader);
            Checkpoints.checkpoint("extension-stopped");
        }
        return true;
    }

    public void addBeforeExtensionStopCallback(@NotNull Consumer<HiveMQExtension> callback) {
        Lock lock = this.beforeExtensionStopCallbacksLock.writeLock();
        try {
            lock.lock();
            this.beforeExtensionStopCallbacks.add(callback);
        }
        finally {
            lock.unlock();
        }
    }

    public void addAfterExtensionStopCallback(@NotNull Consumer<HiveMQExtension> callback) {
        Lock lock = this.afterExtensionStopCallbacksLock.writeLock();
        try {
            lock.lock();
            this.afterExtensionStopCallbacks.add(callback);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBeforeExtensionStopCallbacks(@NotNull HiveMQExtension extension) {
        Lock lock = this.beforeExtensionStopCallbacksLock.readLock();
        try {
            lock.lock();
            for (Consumer<HiveMQExtension> callback : this.beforeExtensionStopCallbacks) {
                callback.accept(extension);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAfterExtensionStopCallbacks(@NotNull HiveMQExtension extension) {
        Lock lock = this.afterExtensionStopCallbacksLock.readLock();
        try {
            lock.lock();
            for (Consumer<HiveMQExtension> callback : this.afterExtensionStopCallbacks) {
                callback.accept(extension);
            }
        }
        finally {
            lock.unlock();
        }
    }
}

