/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.auth.AuthContext;
import com.hivemq.extensions.auth.ConnectAuthOutput;
import com.hivemq.mqtt.handler.auth.MqttAuthSender;
import com.hivemq.mqtt.handler.connack.MqttConnacker;
import com.hivemq.mqtt.handler.connect.ConnectHandler;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import io.netty.channel.ChannelHandlerContext;

public class ConnectAuthContext
extends AuthContext<ConnectAuthOutput> {
    @NotNull
    private final ConnectHandler connectHandler;
    @NotNull
    private final MqttConnacker connacker;
    @NotNull
    private final CONNECT connect;
    private final boolean initial;

    public ConnectAuthContext(@NotNull ChannelHandlerContext ctx, @NotNull MqttAuthSender authSender, int authenticatorsCount, @NotNull ConnectAuthOutput output, @NotNull ConnectHandler connectHandler, @NotNull MqttConnacker connacker, @NotNull CONNECT connect, boolean initial) {
        super(connect.getClientIdentifier(), ctx, authSender, authenticatorsCount, output);
        this.connectHandler = connectHandler;
        this.connacker = connacker;
        this.connect = connect;
        this.initial = initial;
    }

    @Override
    @NotNull
    ConnectAuthOutput createNextOutput(@NotNull ConnectAuthOutput prevOutput) {
        return new ConnectAuthOutput(prevOutput);
    }

    @Override
    void succeedAuthentication(@NotNull ConnectAuthOutput output) {
        super.succeedAuthentication(output);
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(this.ctx.channel());
        clientConnectionContext.setAuthData(output.getAuthenticationData());
        clientConnectionContext.setAuthUserProperties(Mqtt5UserProperties.of(output.getOutboundUserProperties().asInternalList()));
        this.connectHandler.connectSuccessfulAuthenticated(this.ctx, clientConnectionContext, this.connect, output.getClientSettings());
    }

    @Override
    void failAuthentication(@NotNull ConnectAuthOutput output) {
        this.connacker.connackError(this.ctx.channel(), "Client with ip {} could not be authenticated", output.getReasonString(), output.getReasonCode(), output.getReasonString(), Mqtt5UserProperties.of(output.getOutboundUserProperties().asInternalList()), true);
    }

    @Override
    void undecidedAuthentication(@NotNull ConnectAuthOutput output) {
        if (this.initial) {
            ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(this.ctx.channel());
            this.connectHandler.connectSuccessfulUndecided(this.ctx, clientConnectionContext, this.connect, output.getClientSettings());
        } else {
            this.connacker.connackError(this.ctx.channel(), "Client with ip {} could not be authenticated", "Authentication failed, no authenticator registered", Mqtt5ConnAckReasonCode.NOT_AUTHORIZED, "Authentication failed, no authenticator registered", Mqtt5UserProperties.NO_USER_PROPERTIES, true);
        }
    }

    @Override
    void onTimeout() {
        this.connacker.connackError(this.ctx.channel(), "Client with ip {} could not be authenticated", "Authentication failed, timeout before the client provided required authentication data", Mqtt5ConnAckReasonCode.NOT_AUTHORIZED, "Authentication failed, timeout before the client provided required authentication data", Mqtt5UserProperties.NO_USER_PROPERTIES, true);
    }

    @Override
    void onSendException(@NotNull Throwable cause) {
        this.connacker.connackError(this.ctx.channel(), "Client with ip {} could not be authenticated", "Authentication failed, could not send AUTH to client", Mqtt5ConnAckReasonCode.NOT_AUTHORIZED, "Authentication failed, could not send AUTH to client", Mqtt5UserProperties.NO_USER_PROPERTIES, true);
    }
}

