/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.client.parameter;

import com.google.common.base.Preconditions;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.client.parameter.ClientTlsInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionAttributeStore;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.client.parameter.Listener;
import com.hivemq.extension.sdk.api.client.parameter.ProxyInformation;
import com.hivemq.extension.sdk.api.client.parameter.TlsInformation;
import com.hivemq.extension.sdk.api.packets.general.MqttVersion;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.client.parameter.ConnectionAttributeStoreImpl;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.util.Optional;

public class ConnectionInformationImpl
implements ConnectionInformation {
    @NotNull
    private final MqttVersion mqttVersion;
    @NotNull
    private final ConnectionAttributeStore connectionAttributeStore;
    @Nullable
    private final InetAddress inetAddress;
    @Nullable
    private final Listener listener;
    @Nullable
    private final ClientTlsInformation tlsInformation;

    public ConnectionInformationImpl(@NotNull ClientConnectionContext clientConnectionContext) {
        Preconditions.checkNotNull((Object)clientConnectionContext);
        Channel channel = clientConnectionContext.getChannel();
        Preconditions.checkNotNull((Object)channel);
        this.mqttVersion = ExtensionInformationUtil.mqttVersionFromChannel(channel);
        this.inetAddress = clientConnectionContext.getChannelAddress().orElse(null);
        this.listener = ExtensionInformationUtil.getListenerFromChannel(channel);
        this.tlsInformation = ExtensionInformationUtil.getTlsInformationFromChannel(channel);
        this.connectionAttributeStore = new ConnectionAttributeStoreImpl(channel);
    }

    @NotNull
    public MqttVersion getMqttVersion() {
        return this.mqttVersion;
    }

    @NotNull
    public Optional<InetAddress> getInetAddress() {
        return Optional.ofNullable(this.inetAddress);
    }

    @NotNull
    public Optional<Listener> getListener() {
        return Optional.ofNullable(this.listener);
    }

    @NotNull
    public Optional<ProxyInformation> getProxyInformation() {
        return Optional.empty();
    }

    @NotNull
    public ConnectionAttributeStore getConnectionAttributeStore() {
        return this.connectionAttributeStore;
    }

    @NotNull
    public Optional<TlsInformation> getTlsInformation() {
        if (this.tlsInformation != null && this.tlsInformation.getClientCertificate().isPresent() && this.tlsInformation.getClientCertificateChain().isPresent()) {
            return Optional.of((TlsInformation)this.tlsInformation);
        }
        return Optional.empty();
    }

    @NotNull
    public Optional<ClientTlsInformation> getClientTlsInformation() {
        return Optional.ofNullable(this.tlsInformation);
    }
}

