/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.events;

import com.google.common.collect.ImmutableMap;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.events.client.ClientLifecycleEventListenerProvider;
import com.hivemq.extensions.ExtensionPriorityComparator;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.events.LifecycleEventListeners;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class LifecycleEventListenersImpl
implements LifecycleEventListeners {
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull ClientLifecycleEventListenerProvider> clientLifecycleEventListenerProviderMap;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final ReadWriteLock readWriteLock;

    @Inject
    public LifecycleEventListenersImpl(@NotNull HiveMQExtensions hiveMQExtensions) {
        this.hiveMQExtensions = hiveMQExtensions;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.clientLifecycleEventListenerProviderMap = new TreeMap<String, ClientLifecycleEventListenerProvider>(new ExtensionPriorityComparator(hiveMQExtensions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClientLifecycleEventListenerProvider(@NotNull ClientLifecycleEventListenerProvider provider) {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            ClassLoader pluginClassloader = provider.getClass().getClassLoader();
            HiveMQExtension plugin = this.hiveMQExtensions.getExtensionForClassloader(pluginClassloader);
            if (plugin != null) {
                this.clientLifecycleEventListenerProviderMap.put(plugin.getId(), provider);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull String, @NotNull ClientLifecycleEventListenerProvider> getClientLifecycleEventListenerProviderMap() {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.clientLifecycleEventListenerProviderMap);
            return immutableMap;
        }
        finally {
            lock.unlock();
        }
    }
}

