/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.loader;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableMap;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.events.EventRegistry;
import com.hivemq.extension.sdk.api.services.ManagedExtensionExecutorService;
import com.hivemq.extension.sdk.api.services.admin.AdminService;
import com.hivemq.extension.sdk.api.services.auth.SecurityRegistry;
import com.hivemq.extension.sdk.api.services.cluster.ClusterService;
import com.hivemq.extension.sdk.api.services.interceptor.GlobalInterceptorRegistry;
import com.hivemq.extension.sdk.api.services.intializer.InitializerRegistry;
import com.hivemq.extension.sdk.api.services.publish.PublishService;
import com.hivemq.extension.sdk.api.services.publish.RetainedMessageStore;
import com.hivemq.extension.sdk.api.services.session.ClientService;
import com.hivemq.extension.sdk.api.services.subscription.SubscriptionStore;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.loader.ExtensionServicesDependencies;
import com.hivemq.extensions.services.executor.GlobalManagedExtensionExecutorService;
import com.hivemq.extensions.services.executor.ManagedExecutorServicePerExtension;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ExtensionServicesDependenciesImpl
implements ExtensionServicesDependencies {
    @NotNull
    private final MetricRegistry metricRegistry;
    @NotNull
    private final InitializerRegistry initializerRegistry;
    @NotNull
    private final RetainedMessageStore retainedMessageStore;
    @NotNull
    private final ClientService clientService;
    @NotNull
    private final SubscriptionStore subscriptionStore;
    @NotNull
    private final GlobalManagedExtensionExecutorService globalManagedExtensionExecutorService;
    @NotNull
    private final PublishService publishService;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final SecurityRegistry securityRegistry;
    @NotNull
    private final EventRegistry eventRegistry;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final GlobalInterceptorRegistry globalInterceptorRegistry;
    @NotNull
    private final AdminService adminService;

    @Inject
    public ExtensionServicesDependenciesImpl(@NotNull MetricRegistry metricRegistry, @NotNull InitializerRegistry initializerRegistry, @NotNull RetainedMessageStore retainedMessageStore, @NotNull ClientService clientService, @NotNull SubscriptionStore subscriptionStore, @NotNull GlobalManagedExtensionExecutorService globalManagedExtensionExecutorService, @NotNull PublishService publishService, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull SecurityRegistry securityRegistry, @NotNull EventRegistry eventRegistry, @NotNull ClusterService clusterService, @NotNull GlobalInterceptorRegistry globalInterceptorRegistry, @NotNull AdminService adminService) {
        this.metricRegistry = metricRegistry;
        this.publishService = publishService;
        this.securityRegistry = securityRegistry;
        this.initializerRegistry = initializerRegistry;
        this.retainedMessageStore = retainedMessageStore;
        this.clientService = clientService;
        this.subscriptionStore = subscriptionStore;
        this.globalManagedExtensionExecutorService = globalManagedExtensionExecutorService;
        this.hiveMQExtensions = hiveMQExtensions;
        this.eventRegistry = eventRegistry;
        this.clusterService = clusterService;
        this.globalInterceptorRegistry = globalInterceptorRegistry;
        this.adminService = adminService;
    }

    @Override
    @NotNull
    public ImmutableMap<String, Object> getDependenciesMap(@NotNull ClassLoader classLoader) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)MetricRegistry.class.getCanonicalName(), (Object)this.metricRegistry);
        builder.put((Object)SecurityRegistry.class.getCanonicalName(), (Object)this.securityRegistry);
        builder.put((Object)InitializerRegistry.class.getCanonicalName(), (Object)this.initializerRegistry);
        builder.put((Object)RetainedMessageStore.class.getCanonicalName(), (Object)this.retainedMessageStore);
        builder.put((Object)ClientService.class.getCanonicalName(), (Object)this.clientService);
        builder.put((Object)SubscriptionStore.class.getCanonicalName(), (Object)this.subscriptionStore);
        builder.put((Object)PublishService.class.getCanonicalName(), (Object)this.publishService);
        builder.put((Object)ManagedExtensionExecutorService.class.getCanonicalName(), (Object)this.getManagedExecutorService(classLoader));
        builder.put((Object)EventRegistry.class.getCanonicalName(), (Object)this.eventRegistry);
        builder.put((Object)ClusterService.class.getCanonicalName(), (Object)this.clusterService);
        builder.put((Object)GlobalInterceptorRegistry.class.getCanonicalName(), (Object)this.globalInterceptorRegistry);
        builder.put((Object)AdminService.class.getCanonicalName(), (Object)this.adminService);
        return builder.build();
    }

    @NotNull
    private ManagedExecutorServicePerExtension getManagedExecutorService(@NotNull ClassLoader classLoader) {
        return new ManagedExecutorServicePerExtension(this.globalManagedExtensionExecutorService, classLoader, this.hiveMQExtensions);
    }
}

