/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.general;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.auth.parameter.TopicPermission;
import com.hivemq.extension.sdk.api.packets.auth.DefaultAuthorizationBehaviour;
import com.hivemq.extension.sdk.api.packets.auth.ModifiableDefaultPermissions;
import com.hivemq.extension.sdk.api.services.exception.DoNotImplementException;
import com.hivemq.extensions.auth.parameter.TopicPermissionImpl;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class ModifiableDefaultPermissionsImpl
implements ModifiableDefaultPermissions {
    @NotNull
    private ImmutableList<TopicPermission> topicPermissions = ImmutableList.of();
    private final AtomicReference<DefaultAuthorizationBehaviour> defaultAuthorizationBehaviour = new AtomicReference<DefaultAuthorizationBehaviour>(DefaultAuthorizationBehaviour.ALLOW);
    private final AtomicBoolean defaultAuthorizationBehaviourOverridden = new AtomicBoolean(false);

    @NotNull
    public List<TopicPermission> asList() {
        return this.topicPermissions;
    }

    public void add(@NotNull TopicPermission permission) {
        Preconditions.checkNotNull((Object)permission, (Object)"Permission cannot be null");
        if (!(permission instanceof TopicPermissionImpl)) {
            throw new DoNotImplementException("Topic permission must be created with Builders.topicPermission()");
        }
        if (!this.defaultAuthorizationBehaviourOverridden.get()) {
            this.defaultAuthorizationBehaviour.set(DefaultAuthorizationBehaviour.DENY);
        }
        this.topicPermissions = ImmutableList.builder().addAll(this.topicPermissions).add((Object)permission).build();
    }

    public void addAll(@NotNull Collection<? extends TopicPermission> permissions) {
        Preconditions.checkNotNull(permissions, (Object)"Permissions cannot be null");
        for (TopicPermission topicPermission : permissions) {
            Preconditions.checkNotNull((Object)topicPermission, (Object)"Permission in the list cannot be null");
            if (topicPermission instanceof TopicPermissionImpl) continue;
            throw new DoNotImplementException("Topic permission must be created with Builders.topicPermission()");
        }
        if (!this.defaultAuthorizationBehaviourOverridden.get()) {
            this.defaultAuthorizationBehaviour.set(DefaultAuthorizationBehaviour.DENY);
        }
        this.topicPermissions = ImmutableList.builder().addAll(this.topicPermissions).addAll(permissions).build();
    }

    public void remove(@NotNull TopicPermission permission) {
        Preconditions.checkNotNull((Object)permission, (Object)"Permission cannot be null");
        if (!(permission instanceof TopicPermissionImpl)) {
            throw new DoNotImplementException("Topic permission must be created with Builders.topicPermission()");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.topicPermissions.size(); ++i) {
            TopicPermission topicPermission = (TopicPermission)this.topicPermissions.get(i);
            if (topicPermission.equals(permission)) continue;
            builder.add((Object)topicPermission);
        }
        this.topicPermissions = builder.build();
    }

    public void clear() {
        this.topicPermissions = ImmutableList.of();
    }

    @NotNull
    public DefaultAuthorizationBehaviour getDefaultBehaviour() {
        return this.defaultAuthorizationBehaviour.get();
    }

    public void setDefaultBehaviour(@NotNull DefaultAuthorizationBehaviour defaultBehaviour) {
        Preconditions.checkNotNull((Object)defaultBehaviour, (Object)"Default behaviour cannot be null");
        this.defaultAuthorizationBehaviourOverridden.set(true);
        this.defaultAuthorizationBehaviour.set(defaultBehaviour);
    }

    public boolean isDefaultAuthorizationBehaviourOverridden() {
        return this.defaultAuthorizationBehaviourOverridden.get();
    }
}

