/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.general;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.packets.general.UserProperties;
import com.hivemq.extension.sdk.api.packets.general.UserProperty;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import java.util.Objects;
import java.util.Optional;

public class UserPropertiesImpl
implements UserProperties {
    private static final UserPropertiesImpl NO_USER_PROPERTIES = new UserPropertiesImpl((ImmutableList<MqttUserProperty>)ImmutableList.of());
    @NotNull
    private final ImmutableList<MqttUserProperty> list;

    @NotNull
    public static UserPropertiesImpl of(@NotNull ImmutableList<MqttUserProperty> list) {
        return list.isEmpty() ? NO_USER_PROPERTIES : new UserPropertiesImpl(list);
    }

    private UserPropertiesImpl(@NotNull ImmutableList<MqttUserProperty> list) {
        this.list = list;
    }

    @NotNull
    public Optional<String> getFirst(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name must never be null");
        return this.list.stream().filter(userProperty -> userProperty.getName().equals(name)).findFirst().map(UserProperty::getValue);
    }

    @NotNull
    public ImmutableList<String> getAllForName(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name must never be null");
        return (ImmutableList)this.list.stream().filter(userProperty -> userProperty.getName().equals(name)).map(UserProperty::getValue).collect(ImmutableList.toImmutableList());
    }

    @NotNull
    public ImmutableList<UserProperty> asList() {
        return ImmutableList.copyOf(this.list);
    }

    @NotNull
    public ImmutableList<MqttUserProperty> asInternalList() {
        return this.list;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserPropertiesImpl)) {
            return false;
        }
        UserPropertiesImpl that = (UserPropertiesImpl)o;
        return this.list.equals(that.list);
    }

    public int hashCode() {
        return Objects.hash(this.list);
    }
}

