/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.auth;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.services.auth.SecurityRegistry;
import com.hivemq.extension.sdk.api.services.auth.provider.AuthenticatorProvider;
import com.hivemq.extension.sdk.api.services.auth.provider.AuthorizerProvider;
import com.hivemq.extension.sdk.api.services.auth.provider.EnhancedAuthenticatorProvider;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.services.auth.Authenticators;
import com.hivemq.extensions.services.auth.Authorizers;
import com.hivemq.extensions.services.auth.WrappedAuthenticatorProvider;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SecurityRegistryImpl
implements SecurityRegistry {
    @NotNull
    private final Authenticators authenticators;
    @NotNull
    private final Authorizers authorizers;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;

    @Inject
    public SecurityRegistryImpl(@NotNull Authenticators authenticators, @NotNull Authorizers authorizers, @NotNull HiveMQExtensions hiveMQExtensions) {
        this.authenticators = authenticators;
        this.authorizers = authorizers;
        this.hiveMQExtensions = hiveMQExtensions;
    }

    public void setAuthenticatorProvider(@NotNull AuthenticatorProvider authenticatorProvider) {
        Preconditions.checkNotNull((Object)authenticatorProvider, (Object)"authenticatorProvider must not be null");
        HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(authenticatorProvider.getClass().getClassLoader());
        if (extension == null || extension.getExtensionClassloader() == null) {
            return;
        }
        WrappedAuthenticatorProvider wrapped = new WrappedAuthenticatorProvider(authenticatorProvider, extension.getExtensionClassloader());
        this.authenticators.registerAuthenticatorProvider(wrapped);
    }

    public void setEnhancedAuthenticatorProvider(@NotNull EnhancedAuthenticatorProvider enhancedAuthenticatorProvider) {
        Preconditions.checkNotNull((Object)enhancedAuthenticatorProvider, (Object)"enhancedAuthenticatorProvider must not be null");
        HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(enhancedAuthenticatorProvider.getClass().getClassLoader());
        if (extension == null || extension.getExtensionClassloader() == null) {
            return;
        }
        WrappedAuthenticatorProvider wrapped = new WrappedAuthenticatorProvider(enhancedAuthenticatorProvider, extension.getExtensionClassloader());
        this.authenticators.registerAuthenticatorProvider(wrapped);
    }

    public void setAuthorizerProvider(@NotNull AuthorizerProvider authorizerProvider) {
        Preconditions.checkNotNull((Object)authorizerProvider, (Object)"authorizerProvider must not be null");
        this.authorizers.addAuthorizerProvider(authorizerProvider);
    }
}

