/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.executor;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;

public class WrappedCallable<V>
implements Callable<V> {
    @NotNull
    private final Callable<V> callable;
    @NotNull
    private final ClassLoader classLoader;
    @Nullable
    private final CompletableFuture<V> completableFuture;

    WrappedCallable(@NotNull Callable<V> callable, @NotNull ClassLoader classLoader, @Nullable CompletableFuture<V> completableFuture) {
        this.callable = callable;
        this.classLoader = classLoader;
        this.completableFuture = completableFuture;
    }

    @Override
    @Nullable
    public V call() throws Exception {
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            V call = this.callable.call();
            if (this.completableFuture != null) {
                this.completableFuture.complete(call);
            }
            V v = call;
            return v;
        }
        catch (Throwable t) {
            if (this.completableFuture != null) {
                this.completableFuture.completeExceptionally(t);
            }
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
    }
}

