/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.publish;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.configuration.HivemqId;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.services.exception.DoNotImplementException;
import com.hivemq.extension.sdk.api.services.publish.Publish;
import com.hivemq.extension.sdk.api.services.publish.PublishService;
import com.hivemq.extension.sdk.api.services.publish.PublishToClientResult;
import com.hivemq.extensions.ListenableFutureConverter;
import com.hivemq.extensions.services.PluginServiceRateLimitService;
import com.hivemq.extensions.services.executor.GlobalManagedExtensionExecutorService;
import com.hivemq.extensions.services.publish.PublishImpl;
import com.hivemq.mqtt.handler.publish.PublishReturnCode;
import com.hivemq.mqtt.handler.publish.PublishStatus;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.publish.PUBLISHFactory;
import com.hivemq.mqtt.services.InternalPublishService;
import com.hivemq.mqtt.services.PublishDistributor;
import com.hivemq.mqtt.topic.SubscriberWithIdentifiers;
import com.hivemq.mqtt.topic.tree.LocalTopicTree;
import com.hivemq.util.Bytes;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.inject.Inject;

@LazySingleton
public class PublishServiceImpl
implements PublishService {
    @NotNull
    private final PluginServiceRateLimitService rateLimitService;
    @NotNull
    private final GlobalManagedExtensionExecutorService globalManagedExtensionExecutorService;
    @NotNull
    private final InternalPublishService internalPublishService;
    @NotNull
    private final PublishDistributor publishDistributor;
    @NotNull
    private final HivemqId hiveMQId;
    @NotNull
    private final LocalTopicTree topicTree;

    @Inject
    public PublishServiceImpl(@NotNull PluginServiceRateLimitService rateLimitService, @NotNull GlobalManagedExtensionExecutorService globalManagedExtensionExecutorService, @NotNull InternalPublishService internalPublishService, @NotNull PublishDistributor publishDistributor, @NotNull HivemqId hiveMQId, @NotNull LocalTopicTree topicTree) {
        this.rateLimitService = rateLimitService;
        this.globalManagedExtensionExecutorService = globalManagedExtensionExecutorService;
        this.internalPublishService = internalPublishService;
        this.publishDistributor = publishDistributor;
        this.hiveMQId = hiveMQId;
        this.topicTree = topicTree;
    }

    @NotNull
    public CompletableFuture<Void> publish(@NotNull Publish publish) {
        Preconditions.checkNotNull((Object)publish, (Object)"Publish must never be null");
        if (this.rateLimitService.rateLimitExceeded()) {
            return CompletableFuture.failedFuture((Throwable)PluginServiceRateLimitService.RATE_LIMIT_EXCEEDED_EXCEPTION);
        }
        if (!(publish instanceof PublishImpl)) {
            return CompletableFuture.failedFuture((Throwable)new DoNotImplementException(Publish.class.getSimpleName()));
        }
        PUBLISH internalPublish = this.publishToPUBLISH((PublishImpl)publish);
        ListenableFuture<PublishReturnCode> publishFuture = this.internalPublishService.publish(internalPublish, this.globalManagedExtensionExecutorService, null);
        return ListenableFutureConverter.toVoidCompletable(publishFuture, this.globalManagedExtensionExecutorService);
    }

    @NotNull
    public CompletableFuture<PublishToClientResult> publishToClient(@NotNull Publish publish, @NotNull String clientId) {
        Preconditions.checkNotNull((Object)publish, (Object)"Publish must never be null");
        Preconditions.checkNotNull((Object)clientId, (Object)"Client ID must never be null");
        Preconditions.checkArgument((!clientId.isEmpty() ? 1 : 0) != 0, (Object)"Client ID must not be empty");
        if (this.rateLimitService.rateLimitExceeded()) {
            return CompletableFuture.failedFuture((Throwable)PluginServiceRateLimitService.RATE_LIMIT_EXCEEDED_EXCEPTION);
        }
        if (!(publish instanceof PublishImpl)) {
            return CompletableFuture.failedFuture((Throwable)new DoNotImplementException(Publish.class.getSimpleName()));
        }
        PUBLISH internalPublish = this.publishToPUBLISH((PublishImpl)publish);
        final SettableFuture sendPublishFuture = SettableFuture.create();
        SubscriberWithIdentifiers subscriber = this.topicTree.findSubscriber(clientId, publish.getTopic());
        if (subscriber == null) {
            sendPublishFuture.set((Object)PublishToClientResult.NOT_SUBSCRIBED);
            return ListenableFutureConverter.toCompletable(sendPublishFuture, this.globalManagedExtensionExecutorService);
        }
        ListenableFuture<PublishStatus> publishSendFuture = this.publishDistributor.sendMessageToSubscriber(internalPublish, clientId, subscriber.getQos(), false, subscriber.isRetainAsPublished(), subscriber.getSubscriptionIdentifier());
        Futures.addCallback(publishSendFuture, (FutureCallback)new FutureCallback<PublishStatus>(){

            public void onSuccess(@Nullable PublishStatus result) {
                sendPublishFuture.set((Object)PublishToClientResult.SUCCESSFUL);
            }

            public void onFailure(@NotNull Throwable t) {
                sendPublishFuture.setException(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ListenableFutureConverter.toCompletable(sendPublishFuture, this.globalManagedExtensionExecutorService);
    }

    @NotNull
    private PUBLISH publishToPUBLISH(@NotNull PublishImpl publish) {
        byte[] payload = Bytes.getBytesFromReadOnlyBuffer(publish.getPayload());
        byte[] correlationData = Bytes.getBytesFromReadOnlyBuffer(publish.getCorrelationData());
        Mqtt5PayloadFormatIndicator payloadFormatIndicator = publish.getPayloadFormatIndicator().isPresent() ? Mqtt5PayloadFormatIndicator.from(publish.getPayloadFormatIndicator().get()) : null;
        return new PUBLISHFactory.Mqtt5Builder().withHivemqId(this.hiveMQId.get()).withQoS(QoS.valueOf(publish.getQos().getQosNumber())).withOnwardQos(QoS.valueOf(publish.getQos().getQosNumber())).withRetain(publish.getRetain()).withTopic(publish.getTopic()).withPayload(payload).withMessageExpiryInterval(publish.getMessageExpiryInterval().orElse(Long.MAX_VALUE)).withResponseTopic(publish.getResponseTopic().orElse(null)).withCorrelationData(correlationData).withPayload(payload).withContentType(publish.getContentType().orElse(null)).withPayloadFormatIndicator(payloadFormatIndicator).withUserProperties(Mqtt5UserProperties.of(publish.getUserProperties().asInternalList())).build();
    }
}

