/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import io.netty.channel.Channel;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jctools.queues.MpscLinkedQueue;

@Singleton
public class KeepAliveDisconnectService {
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;
    @NotNull
    private final MpscLinkedQueue<Channel> disconnectQueue = new MpscLinkedQueue();
    @NotNull
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    private final long disconnectBatch;
    private final AtomicInteger submittedTasks = new AtomicInteger();

    @Inject
    public KeepAliveDisconnectService(@NotNull MqttServerDisconnector mqttServerDisconnector, @NotNull ShutdownHooks shutdownHooks) {
        this.mqttServerDisconnector = mqttServerDisconnector;
        this.disconnectBatch = 100L;
        shutdownHooks.add(new HiveMQShutdownHook(){

            @Override
            @NotNull
            public String name() {
                return "KeepAliveDisconnectService shutdown";
            }

            @Override
            public void run() {
                KeepAliveDisconnectService.this.scheduledExecutorService.shutdown();
            }
        });
    }

    public void submitKeepAliveDisconnect(@NotNull Channel channel) {
        this.disconnectQueue.offer((Object)channel);
        if (this.submittedTasks.getAndIncrement() == 0) {
            try {
                this.scheduledExecutorService.schedule(new DisconnectorTask(), 100L, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    public class DisconnectorTask
    implements Runnable {
        @Override
        public void run() {
            int i = 0;
            try {
                while ((long)i < KeepAliveDisconnectService.this.disconnectBatch) {
                    Channel channel = (Channel)KeepAliveDisconnectService.this.disconnectQueue.relaxedPoll();
                    if (channel == null) {
                        break;
                    }
                    ++i;
                    channel.eventLoop().execute(() -> KeepAliveDisconnectService.this.mqttServerDisconnector.disconnect(channel, "Client with ID {} and IP {} disconnected. The client was idle for too long without sending an MQTT control packet", "Client was idle for too long", Mqtt5DisconnectReasonCode.KEEP_ALIVE_TIMEOUT, "The client was idle for too long without sending an MQTT control packet."));
                }
            }
            finally {
                if (KeepAliveDisconnectService.this.submittedTasks.addAndGet(-i) > 0) {
                    try {
                        KeepAliveDisconnectService.this.scheduledExecutorService.schedule(this, 100L, TimeUnit.MILLISECONDS);
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {}
                }
            }
        }
    }
}

