/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.disconnect;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ClientState;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.events.OnClientDisconnectEvent;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.limitation.TopicAliasLimiter;
import com.hivemq.logging.EventLog;
import com.hivemq.metrics.MetricsHolder;
import com.hivemq.mqtt.message.disconnect.DISCONNECT;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.persistence.clientsession.ClientSessionPersistence;
import com.hivemq.persistence.connection.ConnectionPersistence;
import com.hivemq.util.Checkpoints;
import com.hivemq.util.Exceptions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ChannelHandler.Sharable
public class DisconnectHandler
extends SimpleChannelInboundHandler<DISCONNECT> {
    private static final Logger log = LoggerFactory.getLogger(DisconnectHandler.class);
    @NotNull
    private final EventLog eventLog;
    @NotNull
    private final MetricsHolder metricsHolder;
    @NotNull
    private final TopicAliasLimiter topicAliasLimiter;
    @NotNull
    private final ClientSessionPersistence clientSessionPersistence;
    @NotNull
    private final ConnectionPersistence connectionPersistence;
    private final boolean logClientReasonString;

    @Inject
    public DisconnectHandler(@NotNull EventLog eventLog, @NotNull MetricsHolder metricsHolder, @NotNull TopicAliasLimiter topicAliasLimiter, @NotNull ClientSessionPersistence clientSessionPersistence, @NotNull ConnectionPersistence connectionPersistence) {
        this.eventLog = eventLog;
        this.metricsHolder = metricsHolder;
        this.topicAliasLimiter = topicAliasLimiter;
        this.clientSessionPersistence = clientSessionPersistence;
        this.connectionPersistence = connectionPersistence;
        this.logClientReasonString = true;
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull DISCONNECT msg) throws Exception {
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(ctx.channel());
        clientConnectionContext.proposeClientState(ClientState.DISCONNECTING);
        String clientId = clientConnectionContext.getClientId();
        if (msg.getSessionExpiryInterval() != Long.MAX_VALUE) {
            clientConnectionContext.setClientSessionExpiryInterval(msg.getSessionExpiryInterval());
        }
        if (log.isTraceEnabled()) {
            log.trace("The client [{}] sent a disconnect message.", (Object)clientId);
        }
        this.eventLog.clientDisconnectedGracefully(clientConnectionContext, this.logClientReasonString ? msg.getReasonString() : null);
        clientConnectionContext.setSendWill(msg.getReasonCode() != Mqtt5DisconnectReasonCode.NORMAL_DISCONNECTION);
        ctx.pipeline().fireUserEventTriggered((Object)new OnClientDisconnectEvent(((Mqtt5DisconnectReasonCode)msg.getReasonCode()).toDisconnectedReasonCode(), msg.getReasonString(), UserPropertiesImpl.of(msg.getUserProperties().asList()), true));
        clientConnectionContext.proposeClientState(ClientState.DISCONNECTED_BY_CLIENT);
        ctx.channel().close();
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        String[] topicAliasMapping;
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(ctx.channel());
        clientConnectionContext.proposeClientState(ClientState.DISCONNECTED_UNSPECIFIED);
        ClientState clientState = clientConnectionContext.getClientState();
        boolean initialDisconnectEvent = clientState == ClientState.DISCONNECTED_UNSPECIFIED;
        this.persistDisconnectState(clientConnectionContext);
        this.metricsHolder.getClosedConnectionsCounter().inc();
        if (initialDisconnectEvent) {
            this.eventLog.clientDisconnectedUngracefully(clientConnectionContext);
            ctx.pipeline().fireUserEventTriggered((Object)new OnClientDisconnectEvent(null, null, null, false));
        }
        if ((topicAliasMapping = clientConnectionContext.getTopicAliasMapping()) != null) {
            this.topicAliasLimiter.finishUsage(topicAliasMapping);
        }
        super.channelInactive(ctx);
    }

    private void persistDisconnectState(final @NotNull ClientConnectionContext clientConnectionContext) {
        SettableFuture<Void> disconnectFuture = clientConnectionContext.getDisconnectFuture();
        if (clientConnectionContext.getClientId() == null || !(clientConnectionContext instanceof ClientConnection)) {
            if (disconnectFuture != null) {
                disconnectFuture.set(null);
            }
            return;
        }
        final ClientConnection clientConnection = (ClientConnection)clientConnectionContext;
        if (clientConnection != this.connectionPersistence.get(clientConnection.getClientId())) {
            if (disconnectFuture != null) {
                disconnectFuture.set(null);
            }
            return;
        }
        if (clientConnection.isPreventLwt()) {
            clientConnection.setSendWill(false);
        } else if (clientConnection.getClientState() == ClientState.DISCONNECTED_BY_SERVER || clientConnection.getClientState() == ClientState.DISCONNECTED_UNSPECIFIED) {
            clientConnection.setSendWill(true);
        }
        ListenableFuture<Void> persistenceFuture = this.clientSessionPersistence.clientDisconnected(clientConnection.getClientId(), clientConnection.isSendWill(), clientConnection.getClientSessionExpiryInterval());
        Futures.addCallback(persistenceFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                DisconnectHandler.this.connectionPersistence.remove(clientConnection);
                Checkpoints.checkpoint("client-disconnected");
                SettableFuture<Void> disconnectFuture = clientConnection.getDisconnectFuture();
                if (disconnectFuture != null) {
                    disconnectFuture.set(null);
                }
            }

            public void onFailure(@NotNull Throwable throwable) {
                boolean persistent = clientConnectionContext.getClientSessionExpiryInterval() > 0L;
                Exceptions.rethrowError("Unable to update client session data for disconnecting client " + clientConnectionContext.getClientId() + " with clean session set to " + !persistent + ".", throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }
}

