/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.publish;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.auth.parameter.TopicPermission;
import com.hivemq.extension.sdk.api.packets.auth.DefaultAuthorizationBehaviour;
import com.hivemq.extension.sdk.api.packets.auth.ModifiableDefaultPermissions;
import com.hivemq.extensions.auth.parameter.InternalTopicPermission;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.connect.MqttWillPublish;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.mqtt.topic.InvalidTopicException;
import com.hivemq.mqtt.topic.PermissionTopicMatcherUtils;
import com.hivemq.persistence.clientsession.SharedSubscriptionService;
import com.hivemq.util.Topics;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class DefaultPermissionsEvaluator {
    private DefaultPermissionsEvaluator() {
    }

    public static boolean checkWillPublish(@Nullable ModifiableDefaultPermissions permissions, @NotNull MqttWillPublish willPublish) {
        return DefaultPermissionsEvaluator.checkPublish(permissions, willPublish.getTopic(), willPublish.getQos(), willPublish.isRetain());
    }

    public static boolean checkPublish(@Nullable ModifiableDefaultPermissions permissions, @NotNull PUBLISH publish) {
        return DefaultPermissionsEvaluator.checkPublish(permissions, publish.getTopic(), publish.getQoS(), publish.isRetain());
    }

    private static boolean checkPublish(@Nullable ModifiableDefaultPermissions permissions, @NotNull String topic, @NotNull QoS qos, boolean retain) {
        if (permissions == null) {
            return false;
        }
        List topicPermissions = permissions.asList();
        if (topicPermissions.size() < 1) {
            return permissions.getDefaultBehaviour() == DefaultAuthorizationBehaviour.ALLOW;
        }
        String[] splitTopic = StringUtils.splitPreserveAllTokens((String)topic, (String)"/");
        String stripedTopic = topic.length() > 1 ? StringUtils.stripEnd((String)topic, (String)"/") : topic;
        for (TopicPermission topicPermission : permissions.asList()) {
            if (!DefaultPermissionsEvaluator.implied(topicPermission, stripedTopic, splitTopic, qos, TopicPermission.MqttActivity.PUBLISH, retain)) continue;
            return topicPermission.getType() == TopicPermission.PermissionType.ALLOW;
        }
        return permissions.getDefaultBehaviour() == DefaultAuthorizationBehaviour.ALLOW;
    }

    public static boolean checkSubscription(@Nullable ModifiableDefaultPermissions permissions, @NotNull Topic subscription) {
        boolean isShared;
        if (permissions == null) {
            return true;
        }
        List topicPermissions = permissions.asList();
        if (topicPermissions.size() < 1) {
            return permissions.getDefaultBehaviour() == DefaultAuthorizationBehaviour.ALLOW;
        }
        String topic = subscription.getTopic();
        String sharedGroup = null;
        if (topic.startsWith("$share/")) {
            SharedSubscriptionService.SharedSubscription sharedSubscription = Topics.checkForSharedSubscription(topic);
            if (sharedSubscription != null) {
                isShared = true;
                topic = sharedSubscription.getTopicFilter();
                sharedGroup = sharedSubscription.getShareName();
            } else {
                isShared = false;
            }
        } else {
            isShared = false;
        }
        String[] splitTopic = StringUtils.splitPreserveAllTokens((String)topic, (String)"/");
        String stripedTopic = topic.length() > 1 ? StringUtils.stripEnd((String)topic, (String)"/") : topic;
        for (TopicPermission topicPermission : permissions.asList()) {
            boolean isImplied = DefaultPermissionsEvaluator.implied(topicPermission, stripedTopic, splitTopic, subscription.getQoS(), TopicPermission.MqttActivity.SUBSCRIBE, isShared, sharedGroup);
            if (!isImplied) continue;
            return topicPermission.getType() == TopicPermission.PermissionType.ALLOW;
        }
        return permissions.getDefaultBehaviour() == DefaultAuthorizationBehaviour.ALLOW;
    }

    private static boolean implied(@NotNull TopicPermission topicPermission, @NotNull String stripedTopic, @NotNull String[] splitTopic, @NotNull QoS messageQoS, @NotNull TopicPermission.MqttActivity activity, boolean retain) {
        if (activity == TopicPermission.MqttActivity.PUBLISH) {
            if (retain && topicPermission.getPublishRetain() == TopicPermission.Retain.NOT_RETAINED) {
                return false;
            }
            if (!retain && topicPermission.getPublishRetain() == TopicPermission.Retain.RETAINED) {
                return false;
            }
        }
        return DefaultPermissionsEvaluator.implied(topicPermission, stripedTopic, splitTopic, messageQoS, activity);
    }

    private static boolean implied(@NotNull TopicPermission topicPermission, @NotNull String stripedTopic, @NotNull String[] splitTopic, @NotNull QoS messageQoS, @NotNull TopicPermission.MqttActivity activity, boolean isShared, @Nullable String sharedGroup) {
        if (topicPermission.getSharedSubscription() == TopicPermission.SharedSubscription.NOT_SHARED && isShared) {
            return false;
        }
        if (topicPermission.getSharedSubscription() == TopicPermission.SharedSubscription.SHARED && !isShared) {
            return false;
        }
        if (sharedGroup != null && !"#".equals(topicPermission.getSharedGroup()) && !sharedGroup.equals(topicPermission.getSharedGroup())) {
            return false;
        }
        return DefaultPermissionsEvaluator.implied(topicPermission, stripedTopic, splitTopic, messageQoS, activity);
    }

    private static boolean implied(@NotNull TopicPermission topicPermission, @NotNull String stripedTopic, @NotNull String[] splitTopic, @NotNull QoS messageQoS, @NotNull TopicPermission.MqttActivity activity) {
        if (topicPermission.getActivity() != TopicPermission.MqttActivity.ALL && topicPermission.getActivity() != activity) {
            return false;
        }
        if (!DefaultPermissionsEvaluator.qosImplied(topicPermission, messageQoS)) {
            return false;
        }
        return DefaultPermissionsEvaluator.topicImplied(topicPermission, stripedTopic, splitTopic);
    }

    private static boolean qosImplied(@NotNull TopicPermission topicPermission, @NotNull QoS qos) {
        TopicPermission.Qos permissionQos = topicPermission.getQos();
        if (permissionQos == TopicPermission.Qos.ALL) {
            return true;
        }
        switch (qos) {
            case AT_MOST_ONCE: {
                return permissionQos == TopicPermission.Qos.ZERO || permissionQos == TopicPermission.Qos.ZERO_ONE || permissionQos == TopicPermission.Qos.ZERO_TWO;
            }
            case AT_LEAST_ONCE: {
                return permissionQos == TopicPermission.Qos.ONE || permissionQos == TopicPermission.Qos.ZERO_ONE || permissionQos == TopicPermission.Qos.ONE_TWO;
            }
            case EXACTLY_ONCE: {
                return permissionQos == TopicPermission.Qos.TWO || permissionQos == TopicPermission.Qos.ZERO_TWO || permissionQos == TopicPermission.Qos.ONE_TWO;
            }
        }
        return false;
    }

    private static boolean topicImplied(@NotNull TopicPermission topicPermission, @NotNull String topic, @NotNull String[] splitTopic) {
        try {
            if (topicPermission instanceof InternalTopicPermission) {
                InternalTopicPermission internalTopicPermission = (InternalTopicPermission)topicPermission;
                return PermissionTopicMatcherUtils.matches(StringUtils.stripEnd((String)topicPermission.getTopicFilter(), (String)"/"), ((InternalTopicPermission)topicPermission).getSplitTopic(), !internalTopicPermission.containsWildcardCharacter(), internalTopicPermission.endsWithWildcard(), internalTopicPermission.isRootWildcard(), topic, splitTopic);
            }
            return false;
        }
        catch (InvalidTopicException e) {
            return false;
        }
    }
}

