/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.dropping;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.logging.EventLog;
import com.hivemq.metrics.MetricsHolder;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import java.text.NumberFormat;
import java.util.Locale;

public class MessageDroppedServiceImpl
implements MessageDroppedService {
    private static final NumberFormat FORMAT = NumberFormat.getInstance(Locale.US);
    @NotNull
    private final MetricsHolder metricsHolder;
    @NotNull
    private final EventLog eventLog;

    MessageDroppedServiceImpl(@NotNull MetricsHolder metricsHolder, @NotNull EventLog eventLog) {
        this.metricsHolder = metricsHolder;
        this.eventLog = eventLog;
    }

    @Override
    public void queueFull(@NotNull String clientId, @NotNull String topic, int qos) {
        this.metricsHolder.getDroppedMessageCounter().inc();
        this.eventLog.messageDropped(clientId, topic, qos, "The client message queue is full");
    }

    @Override
    public void queueFullShared(@NotNull String sharedSubscription, @NotNull String topic, int qos) {
        this.metricsHolder.getDroppedMessageCounter().inc();
        this.eventLog.sharedSubscriptionMessageDropped(sharedSubscription, topic, qos, "The shared subscription message queue is full");
    }

    @Override
    public void qos0MemoryExceeded(@NotNull String clientId, @NotNull String topic, int qos, long currentMemory, long maxMemory) {
        this.metricsHolder.getDroppedMessageCounter().inc();
        String reason = "The QoS 0 memory limit exceeded, size: " + FORMAT.format(currentMemory) + " bytes, max: " + FORMAT.format(maxMemory) + " bytes";
        this.eventLog.messageDropped(clientId, topic, qos, reason);
    }

    @Override
    public void notWritable(@NotNull String clientId, @NotNull String topic, int qos) {
        this.metricsHolder.getDroppedMessageCounter().inc();
        this.eventLog.messageDropped(clientId, topic, qos, "The tcp socket was not writable");
    }

    @Override
    public void extensionPrevented(@NotNull String clientId, @NotNull String topic, int qos) {
        this.metricsHolder.getDroppedMessageCounter().inc();
        this.eventLog.messageDropped(clientId, topic, qos, "Extension prevented onward delivery");
    }

    @Override
    public void failed(@NotNull String clientId, @NotNull String topic, int qos) {
        this.metricsHolder.getDroppedMessageCounter().inc();
        this.eventLog.messageDropped(clientId, topic, qos, "Internal error");
    }

    @Override
    public void failedShared(@NotNull String group, @NotNull String topic, int qos) {
        this.metricsHolder.getDroppedMessageCounter().inc();
        this.eventLog.sharedSubscriptionMessageDropped(group, topic, qos, "Internal error");
    }

    @Override
    public void qos0MemoryExceededShared(@NotNull String group, @NotNull String topic, int qos, long currentMemory, long maxMemory) {
        this.metricsHolder.getDroppedMessageCounter().inc();
        String reason = "The QoS 0 memory limit exceeded, size: " + FORMAT.format(currentMemory) + " bytes, max: " + FORMAT.format(maxMemory) + " bytes";
        this.eventLog.sharedSubscriptionMessageDropped(group, topic, qos, reason);
    }

    @Override
    public void publishMaxPacketSizeExceeded(@NotNull String clientId, @NotNull String topic, int qos, long maximumPacketSize, long packetSize) {
        this.metricsHolder.getDroppedMessageCounter().inc();
        String reason = "Maximum packet size exceeded, size: " + FORMAT.format(packetSize) + " bytes, max: " + FORMAT.format(maximumPacketSize) + " bytes";
        this.eventLog.messageDropped(clientId, topic, qos, reason);
    }

    @Override
    public void messageMaxPacketSizeExceeded(@NotNull String clientId, @NotNull String messageType, long maximumPacketSize, long packetSize) {
        String reason = "Maximum packet size exceeded, size: " + FORMAT.format(packetSize) + " bytes, max: " + FORMAT.format(maximumPacketSize) + " bytes";
        this.eventLog.mqttMessageDropped(clientId, messageType, reason);
    }
}

