/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.topic.tree;

import com.google.common.base.Preconditions;

public final class SegmentKeyUtil {
    private SegmentKeyUtil() {
    }

    public static String segmentKey(String topic, int length) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        Preconditions.checkArgument((!topic.isEmpty() ? 1 : 0) != 0, (Object)"Topic must not be empty");
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"Segment key length must be grater than zero");
        int end = -1;
        for (int i = 0; i < length; ++i) {
            if ((end = topic.indexOf(47, end + 1)) != -1) continue;
            return topic;
        }
        return topic.substring(0, end);
    }

    public static boolean containsWildcard(String segmentKey) {
        if (segmentKey.contains("+")) {
            return true;
        }
        return segmentKey.contains("#");
    }

    public static String firstSegmentKey(String topic) {
        if (topic.isEmpty()) {
            return "";
        }
        return SegmentKeyUtil.segmentKey(topic, 1);
    }
}

