/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence;

import com.google.common.util.concurrent.ListenableFuture;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.LocalPersistence;
import com.hivemq.persistence.ProducerQueues;
import com.hivemq.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPersistence {
    private static final Logger log = LoggerFactory.getLogger(AbstractPersistence.class);

    @NotNull
    protected ListenableFuture<Void> closeDB(@NotNull LocalPersistence localPersistence, @NotNull ProducerQueues singleWriter) {
        return singleWriter.shutdown(bucketIndex -> {
            try {
                localPersistence.closeDB(bucketIndex);
            }
            catch (Throwable t) {
                log.warn("Persistence not closed properly: " + t.getMessage());
                log.debug("Original exception:", t);
                Exceptions.rethrowError(t);
            }
            return null;
        });
    }
}

