/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.ProducerQueues;
import com.hivemq.persistence.ProducerQueuesImpl;
import com.hivemq.persistence.SingleWriterService;
import com.hivemq.persistence.local.xodus.bucket.BucketUtils;
import com.hivemq.util.Exceptions;
import com.hivemq.util.ThreadFactoryUtil;
import java.util.SplittableRandom;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class SingleWriterServiceImpl
implements SingleWriterService {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(SingleWriterServiceImpl.class);
    private static final int AMOUNT_OF_PRODUCERS = 5;
    private static final int RETAINED_MESSAGE_QUEUE_INDEX = 0;
    private static final int CLIENT_SESSION_QUEUE_INDEX = 1;
    private static final int SUBSCRIPTION_QUEUE_INDEX = 2;
    private static final int QUEUED_MESSAGES_QUEUE_INDEX = 3;
    private static final int ATTRIBUTE_STORE_QUEUE_INDEX = 4;
    private final int persistenceBucketCount;
    private final int threadPoolSize;
    private final int creditsPerExecution;
    private final long shutdownGracePeriod;
    @NotNull
    private final AtomicLong nonemptyQueueCounter = new AtomicLong(0L);
    @NotNull
    private final AtomicInteger runningThreadsCount = new AtomicInteger(0);
    @NotNull
    private final AtomicLong globalTaskCount = new AtomicLong(0L);
    @NotNull
    private final @NotNull ProducerQueuesImpl @NotNull [] producers = new ProducerQueuesImpl[5];
    @VisibleForTesting
    @NotNull
    ExecutorService singleWriterExecutor;
    @VisibleForTesting
    @NotNull
    public final @NotNull ExecutorService @NotNull [] callbackExecutors;
    @VisibleForTesting
    @NotNull
    final ScheduledExecutorService checkScheduler;
    private final int amountOfQueues;

    @Inject
    public SingleWriterServiceImpl() {
        int i;
        this.persistenceBucketCount = InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get();
        this.threadPoolSize = InternalConfigurations.SINGLE_WRITER_THREAD_POOL_SIZE.get();
        this.creditsPerExecution = InternalConfigurations.SINGLE_WRITER_CREDITS_PER_EXECUTION.get();
        this.shutdownGracePeriod = InternalConfigurations.PERSISTENCE_SHUTDOWN_GRACE_PERIOD_MSEC.get();
        ThreadFactory threadFactory = ThreadFactoryUtil.create("single-writer-%d");
        this.singleWriterExecutor = Executors.newFixedThreadPool(this.threadPoolSize, threadFactory);
        this.amountOfQueues = this.validAmountOfQueues(this.threadPoolSize, this.persistenceBucketCount);
        for (i = 0; i < this.producers.length; ++i) {
            this.producers[i] = new ProducerQueuesImpl(this, this.amountOfQueues);
        }
        this.callbackExecutors = new ExecutorService[this.amountOfQueues];
        for (i = 0; i < this.amountOfQueues; ++i) {
            ThreadFactory callbackThreadFactory = ThreadFactoryUtil.create("single-writer-callback-" + i);
            ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(callbackThreadFactory);
            this.callbackExecutors[i] = executorService;
        }
        ThreadFactory checkThreadFactory = new ThreadFactoryBuilder().setNameFormat("single-writer-scheduled-check-%d").build();
        this.checkScheduler = Executors.newSingleThreadScheduledExecutor(checkThreadFactory);
    }

    @PostConstruct
    public void postConstruct() {
        this.checkScheduler.scheduleAtFixedRate(() -> {
            try {
                if (this.runningThreadsCount.getAndIncrement() == 0 && !this.singleWriterExecutor.isShutdown()) {
                    this.singleWriterExecutor.submit(new SingleWriterTask(this.nonemptyQueueCounter, this.globalTaskCount, this.runningThreadsCount, this.producers));
                } else {
                    this.runningThreadsCount.decrementAndGet();
                }
            }
            catch (Exception e) {
                log.error("Exception in single writer check task ", (Throwable)e);
            }
        }, InternalConfigurations.SINGLE_WRITER_INTERVAL_TO_CHECK_PENDING_TASKS_AND_SCHEDULE_MSEC.get(), InternalConfigurations.SINGLE_WRITER_INTERVAL_TO_CHECK_PENDING_TASKS_AND_SCHEDULE_MSEC.get(), TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    int validAmountOfQueues(int processorCount, int bucketCount) {
        for (int i = processorCount; i < bucketCount; ++i) {
            if (bucketCount % i != 0) continue;
            return i;
        }
        return this.persistenceBucketCount;
    }

    void incrementNonemptyQueueCounter() {
        this.nonemptyQueueCounter.incrementAndGet();
        if (this.runningThreadsCount.getAndIncrement() < this.threadPoolSize) {
            this.singleWriterExecutor.submit(new SingleWriterTask(this.nonemptyQueueCounter, this.globalTaskCount, this.runningThreadsCount, this.producers));
        } else {
            this.runningThreadsCount.decrementAndGet();
        }
    }

    @Override
    @NotNull
    public ExecutorService callbackExecutor(@NotNull String key) {
        int bucketsPerQueue = this.persistenceBucketCount / this.amountOfQueues;
        int bucketIndex = BucketUtils.getBucket(key, this.persistenceBucketCount);
        int queueIndex = bucketIndex / bucketsPerQueue;
        return this.callbackExecutors[queueIndex];
    }

    public void decrementNonemptyQueueCounter() {
        this.nonemptyQueueCounter.decrementAndGet();
    }

    @Override
    @NotNull
    public ProducerQueues getRetainedMessageQueue() {
        return this.producers[0];
    }

    @Override
    @NotNull
    public ProducerQueues getClientSessionQueue() {
        return this.producers[1];
    }

    @Override
    @NotNull
    public ProducerQueues getSubscriptionQueue() {
        return this.producers[2];
    }

    @Override
    @NotNull
    public ProducerQueues getQueuedMessagesQueue() {
        return this.producers[3];
    }

    @Override
    @NotNull
    public ProducerQueues getAttributeStoreQueue() {
        return this.producers[4];
    }

    @Override
    public int getPersistenceBucketCount() {
        return this.persistenceBucketCount;
    }

    public int getCreditsPerExecution() {
        return this.creditsPerExecution;
    }

    public long getShutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @NotNull
    public AtomicLong getGlobalTaskCount() {
        return this.globalTaskCount;
    }

    @NotNull
    public AtomicLong getNonemptyQueueCounter() {
        return this.nonemptyQueueCounter;
    }

    @NotNull
    public AtomicInteger getRunningThreadsCount() {
        return this.runningThreadsCount;
    }

    @NotNull
    public @NotNull ExecutorService @NotNull [] getCallbackExecutors() {
        return this.callbackExecutors;
    }

    @Override
    public void stop() {
        long start = System.currentTimeMillis();
        if (log.isTraceEnabled()) {
            log.trace("Shutting down single writer");
        }
        this.singleWriterExecutor.shutdown();
        try {
            this.singleWriterExecutor.awaitTermination(this.shutdownGracePeriod, TimeUnit.SECONDS);
            if (log.isTraceEnabled()) {
                log.trace("Finished single writer shutdown in {} ms", (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.singleWriterExecutor.shutdownNow();
        for (ExecutorService callbackExecutor : this.callbackExecutors) {
            callbackExecutor.shutdownNow();
        }
        this.checkScheduler.shutdownNow();
    }

    private static class SingleWriterTask
    implements Runnable {
        @NotNull
        private final AtomicLong nonemptyQueueCounter;
        @NotNull
        private final AtomicLong globalTaskCount;
        @NotNull
        private final AtomicInteger runningThreadsCount;
        private final ProducerQueuesImpl @NotNull [] producers;
        final int @NotNull [] probabilities;
        private static final int MIN_PROBABILITY_IN_PERCENT = 5;
        @NotNull
        private static final SplittableRandom RANDOM = new SplittableRandom();

        public SingleWriterTask(@NotNull AtomicLong nonemptyQueueCounter, @NotNull AtomicLong globalTaskCount, @NotNull AtomicInteger runningThreadsCount, ProducerQueuesImpl @NotNull [] producers) {
            this.nonemptyQueueCounter = nonemptyQueueCounter;
            this.globalTaskCount = globalTaskCount;
            this.runningThreadsCount = runningThreadsCount;
            this.producers = producers;
            this.probabilities = new int[producers.length];
        }

        @Override
        public void run() {
            try {
                SplittableRandom random = RANDOM.split();
                block2: while (this.nonemptyQueueCounter.get() >= (long)this.runningThreadsCount.getAndDecrement()) {
                    int i;
                    this.runningThreadsCount.incrementAndGet();
                    long countSnapShot = this.globalTaskCount.get();
                    if (countSnapShot == 0L) continue;
                    for (int i2 = 0; i2 < this.producers.length; ++i2) {
                        this.probabilities[i2] = (int)(this.producers[i2].getTaskCount().get() * 100L / countSnapShot);
                    }
                    int sumWithoutMins = 0;
                    for (int i3 = 0; i3 < this.probabilities.length; ++i3) {
                        if (this.probabilities[i3] < 5) {
                            this.probabilities[i3] = 5;
                            continue;
                        }
                        sumWithoutMins += this.probabilities[i3];
                    }
                    int surplus = 0;
                    for (i = 0; i < this.probabilities.length; ++i) {
                        surplus += this.probabilities[i];
                    }
                    if ((surplus -= 100) > 0) {
                        for (i = 0; i < this.probabilities.length; ++i) {
                            if (this.probabilities[i] <= 5) continue;
                            int n = i;
                            this.probabilities[n] = this.probabilities[n] - surplus / (sumWithoutMins / this.probabilities[i]);
                        }
                    }
                    int randomInt = random.nextInt(100);
                    int offset = 0;
                    for (int i4 = 0; i4 < this.probabilities.length; ++i4) {
                        if (randomInt <= this.probabilities[i4] + offset) {
                            this.producers[i4].execute(random);
                            continue block2;
                        }
                        offset += this.probabilities[i4];
                    }
                }
            }
            catch (Throwable t) {
                this.runningThreadsCount.decrementAndGet();
                Exceptions.rethrowError("Exception in single writer executor. ", t);
            }
        }
    }
}

