/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.local.xodus.clientsession;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.mqtt5.Mqtt5RetainHandling;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.persistence.local.xodus.XodusUtils;
import com.hivemq.util.Bytes;
import java.nio.charset.StandardCharsets;
import jetbrains.exodus.ByteIterable;

@ThreadSafe
public class ClientSessionSubscriptionXodusSerializer {
    @ThreadSafe
    public byte[] serializeValue(@NotNull Topic topic, long timestamp, long id) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        int retainHandling = topic.getRetainHandling().getCode();
        Preconditions.checkArgument((retainHandling >= 0 && retainHandling <= 2 ? 1 : 0) != 0, (Object)"Retain handling code must be between 0 and 2");
        byte[] topicBytes = topic.getTopic().getBytes(StandardCharsets.UTF_8);
        byte[] bytes = new byte[topicBytes.length + 27];
        int cursor = 0;
        Bytes.copyIntToByteArray(topicBytes.length, bytes, cursor);
        System.arraycopy(topicBytes, 0, bytes, cursor += 4, topicBytes.length);
        Bytes.copyLongToByteArray(timestamp, bytes, cursor += topicBytes.length);
        int qos = topic.getQoS().getQosNumber();
        bytes[cursor += 8] = (byte)qos;
        Bytes.copyLongToByteArray(id, bytes, ++cursor);
        cursor += 8;
        if (topic.isNoLocal()) {
            bytes[cursor] = (byte)(bytes[cursor] | 1);
        }
        if (topic.isRetainAsPublished()) {
            bytes[cursor] = (byte)(bytes[cursor] | 2);
        }
        bytes[++cursor] = (byte)retainHandling;
        ++cursor;
        if (topic.getSubscriptionIdentifier() != null) {
            Bytes.copyIntToByteArray(topic.getSubscriptionIdentifier(), bytes, cursor);
        } else {
            Bytes.copyIntToByteArray(-1, bytes, cursor);
        }
        cursor += 4;
        return bytes;
    }

    @ThreadSafe
    public byte[] serializeTopic(@NotNull String topic) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        byte[] topicBytes = topic.getBytes(StandardCharsets.UTF_8);
        byte[] bytes = new byte[topicBytes.length + 4];
        Bytes.copyIntToByteArray(topicBytes.length, bytes, 0);
        System.arraycopy(topicBytes, 0, bytes, 4, topicBytes.length);
        return bytes;
    }

    @ThreadSafe
    public Topic deserializeValue(@NotNull byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes, (Object)"Bytes must not be null");
        Preconditions.checkArgument((bytes.length > 0 ? 1 : 0) != 0, (Object)"Bytes must be greater than 1");
        int cursor = 0;
        int topicLength = Bytes.readInt(bytes, cursor);
        String topic = new String(bytes, cursor += 4, topicLength, StandardCharsets.UTF_8);
        cursor += topicLength;
        byte qos = bytes[cursor += 8];
        ++cursor;
        boolean noLocal = (bytes[cursor += 8] & 1) != 0;
        boolean retainAsPublished = (bytes[cursor] & 2) != 0;
        byte retainHandlingCode = bytes[++cursor];
        Mqtt5RetainHandling mqtt5RetainHandling = Mqtt5RetainHandling.fromCode(retainHandlingCode);
        Integer subscriptionIdetifier = Bytes.readInt(bytes, ++cursor);
        if (subscriptionIdetifier == -1) {
            subscriptionIdetifier = null;
        }
        cursor += 4;
        return new Topic(topic, QoS.valueOf(qos), noLocal, retainAsPublished, mqtt5RetainHandling, subscriptionIdetifier);
    }

    public long deserializeId(byte[] bytes) {
        return Bytes.readLong(bytes, bytes.length - 14);
    }

    public long deserializeTimestamp(byte[] bytes) {
        return Bytes.readLong(bytes, bytes.length - 23);
    }

    public Topic deserializeValue(ByteIterable value) {
        Preconditions.checkNotNull((Object)value, (Object)"ByteIterable must not be null");
        return this.deserializeValue(XodusUtils.byteIterableToBytes(value));
    }

    public byte[] serializeKey(String client) {
        byte[] clientIdBytes = client.getBytes(StandardCharsets.UTF_8);
        byte[] bytes = new byte[clientIdBytes.length + 10];
        bytes[0] = (byte)(clientIdBytes.length & 0xFF);
        bytes[1] = (byte)(clientIdBytes.length >> 8 & 0xFF);
        System.arraycopy(clientIdBytes, 0, bytes, 2, clientIdBytes.length);
        return bytes;
    }

    public String deserializeKey(byte[] bytes) {
        int clientIdLength = (bytes[0] & 0xFF) + ((bytes[1] & 0xFF) << 8);
        return new String(bytes, 2, clientIdLength, StandardCharsets.UTF_8);
    }
}

