/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.security.ioc;

import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.util.ThreadFactoryUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class SecurityExecutorProvider
implements Provider<ScheduledExecutorService> {
    @NotNull
    private final ScheduledExecutorService sslContextStoreService = Executors.newScheduledThreadPool(2, ThreadFactoryUtil.create("ssl-context-executor-%d"));

    @Inject
    SecurityExecutorProvider(@NotNull ShutdownHooks shutdownHooks) {
        shutdownHooks.add(new HiveMQShutdownHook(){

            @Override
            @NotNull
            public String name() {
                return "Ssl Context Store Executor Shutdown";
            }

            @Override
            @NotNull
            public HiveMQShutdownHook.Priority priority() {
                return HiveMQShutdownHook.Priority.MEDIUM;
            }

            @Override
            public void run() {
                SecurityExecutorProvider.this.sslContextStoreService.shutdownNow();
            }
        });
    }

    public ScheduledExecutorService get() {
        return this.sslContextStoreService;
    }
}

