/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.security.ssl;

import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.logging.LoggingUtils;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.NotSslRecordException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslExceptionHandler
extends ChannelHandlerAdapter {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(SslExceptionHandler.class);
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;

    @Inject
    public SslExceptionHandler(@NotNull MqttServerDisconnector mqttServerDisconnector) {
        this.mqttServerDisconnector = mqttServerDisconnector;
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        if (this.ignorableException(cause, ctx)) {
            return;
        }
        if (cause.getCause() != null) {
            if (cause.getCause() instanceof SSLHandshakeException) {
                SslExceptionHandler.logSSLHandshakeException(ctx, cause);
                String eventLogMessage = LoggingUtils.appendListenerToMessage(ctx.channel(), "SSL handshake failed");
                this.mqttServerDisconnector.logAndClose(ctx.channel(), null, eventLogMessage);
                return;
            }
            if (cause.getCause() instanceof SSLException) {
                SslExceptionHandler.logSSLException(ctx, cause);
                String eventLogMessage = LoggingUtils.appendListenerToMessage(ctx.channel(), "SSL message transmission failed");
                this.mqttServerDisconnector.logAndClose(ctx.channel(), null, eventLogMessage);
                return;
            }
        }
        ctx.fireExceptionCaught(cause);
    }

    private static void logSSLException(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        if (log.isDebugEnabled()) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)cause);
            ClientConnectionContext clientConnection = ClientConnectionContext.of(ctx.channel());
            String clientId = clientConnection.getClientId();
            if (clientId != null) {
                log.debug("SSL message transmission for client {} failed: {}", (Object)clientId, (Object)rootCause.getMessage());
            } else {
                log.debug("SSL message transmission failed for client with IP {}: {}", (Object)clientConnection.getChannelIP().orElse("UNKNOWN"), (Object)rootCause.getMessage());
            }
            log.trace("Original Exception", rootCause);
        }
    }

    private static void logSSLHandshakeException(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        if (log.isDebugEnabled()) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)cause);
            ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(ctx.channel());
            String clientId = clientConnectionContext.getClientId();
            if (clientId != null) {
                log.debug("SSL Handshake for client {} failed: {}", (Object)clientId, (Object)rootCause.getMessage());
            } else {
                log.debug("SSL Handshake failed for client with IP {}: {}", (Object)clientConnectionContext.getChannelIP().orElse("UNKNOWN"), (Object)rootCause.getMessage());
            }
            log.trace("Original Exception", rootCause);
        }
    }

    private boolean ignorableException(@NotNull Throwable cause, @NotNull ChannelHandlerContext ctx) {
        if (cause instanceof NotSslRecordException) {
            if (log.isDebugEnabled()) {
                ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(ctx.channel());
                log.debug("Client {} sent data which is not SSL/TLS to a SSL/TLS listener. Disconnecting client.", (Object)clientConnectionContext.getChannelIP().orElse("UNKNOWN"));
                log.trace("Original Exception:", cause);
            }
            String eventLogMessage = LoggingUtils.appendListenerToMessage(ctx.channel(), "SSL handshake failed");
            this.mqttServerDisconnector.logAndClose(ctx.channel(), null, eventLogMessage);
            return true;
        }
        return false;
    }
}

