/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.commons.Commons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CollectionUtils {
    @SafeVarargs
    public static <T> List<T> toList(T ... elements) {
        ArrayList<T> result = new ArrayList<T>();
        for (T e : elements) {
            result.add(e);
        }
        return result;
    }

    @SafeVarargs
    public static <T> Set<T> toSet(T ... elements) {
        HashSet<T> result = new HashSet<T>();
        for (T e : elements) {
            result.add(e);
        }
        return result;
    }

    @SafeVarargs
    public static <T> List<T> addAll(List<T> list, T ... elements) {
        for (T e : elements) {
            list.add(e);
        }
        return list;
    }

    @SafeVarargs
    public static <T> Set<T> addAll(Set<T> set, T ... elements) {
        for (T e : elements) {
            set.add(e);
        }
        return set;
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        return CollectionUtils.toList(iterable.iterator());
    }

    public static <T> List<T> toList(Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static <T> List<T> toList(Enumeration<T> en) {
        ArrayList<T> result = new ArrayList<T>();
        while (en.hasMoreElements()) {
            result.add(en.nextElement());
        }
        return result;
    }

    public static <T> Set<T> toSet(Iterable<T> iterable) {
        return CollectionUtils.toSet(iterable.iterator());
    }

    public static <T> Set<T> toSet(Iterator<T> iterator) {
        HashSet<T> result = new HashSet<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static <T> Set<T> toSet(Enumeration<T> en) {
        HashSet<T> result = new HashSet<T>();
        while (en.hasMoreElements()) {
            result.add(en.nextElement());
        }
        return result;
    }

    public static String toString(Collection<?> collection, String leadIn, String leadOut, String separator) {
        String result = leadIn;
        boolean first = true;
        for (Object o : collection) {
            if (!first) {
                result = result + separator;
            }
            result = result + o.toString();
            first = false;
        }
        return result + leadOut;
    }

    public static String toStringSpaceSeparated(Collection<?> collection) {
        return CollectionUtils.toString(collection, "", "", " ");
    }

    public static void reverse(Object[] array) {
        Commons.getInstance().reverse(array);
    }
}

