/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.hash;

import java.util.Map;
import jetbrains.exodus.core.dataStructures.hash.AbstractHashMap;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.util.MathUtil;

public class IntLinkedHashMap<V>
extends AbstractHashMap<Integer, V> {
    private Entry<V>[] table;
    private Entry<V> top;
    private Entry<V> back;
    private int capacity;
    private final float loadFactor;
    private int mask;

    public IntLinkedHashMap() {
        this(0);
    }

    public IntLinkedHashMap(int capacity) {
        this(capacity, 1.0f);
    }

    public IntLinkedHashMap(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.init(capacity);
    }

    public V get(int key) {
        Entry<V> e = this.getEntry(key);
        return (V)(e == null ? null : ((Entry)e).value);
    }

    @Override
    public V put(int key, V value) {
        Entry<V>[] table = this.table;
        int index = HashUtil.indexFor(key, table.length, this.mask);
        Entry<V> e = table[index];
        while (e != null) {
            if (((Entry)e).key == key) {
                this.moveToTop(e);
                return e.setValue(value);
            }
            e = ((Entry)e).hashNext;
        }
        e = new Entry<V>(key, value);
        ((Entry)e).hashNext = (Entry)table[index];
        table[index] = e;
        Entry<V> top = this.top;
        ((Entry)e).next = (Entry)top;
        if (top != null) {
            ((Entry)top).previous = (Entry)e;
        } else {
            this.back = e;
        }
        this.top = e;
        ++this.size;
        if (this.removeEldestEntry(this.back)) {
            this.remove(((Entry)this.back).key);
        } else if (this.size > this.capacity) {
            this.rehash(HashUtil.nextCapacity(this.capacity));
        }
        return null;
    }

    @Override
    public V put(Integer key, V value) {
        return this.put((int)key, value);
    }

    public boolean containsKey(int key) {
        return this.getEntry(key) != null;
    }

    public V remove(int key) {
        Entry<V>[] table = this.table;
        int index = HashUtil.indexFor(key, table.length, this.mask);
        Entry e = table[index];
        if (e == null) {
            return null;
        }
        if (e.key == key) {
            table[index] = e.hashNext;
        } else {
            Entry last;
            do {
                last = e;
                if ((e = e.hashNext) != null) continue;
                return null;
            } while (e.key != key);
            last.hashNext = e.hashNext;
        }
        this.unlink(e);
        --this.size;
        return (V)e.value;
    }

    @Override
    public V remove(Object key) {
        return this.remove((Integer)key);
    }

    protected boolean removeEldestEntry(Map.Entry<Integer, V> eldest) {
        return false;
    }

    @Override
    protected Map.Entry<Integer, V> getEntry(Object key) {
        return this.getEntry((Integer)key);
    }

    @Override
    protected void init(int capacity) {
        if (capacity < 4) {
            capacity = 4;
        }
        this.allocateTable(HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor)));
        this.back = null;
        this.top = null;
        this.capacity = capacity;
        this.size = 0;
    }

    @Override
    protected AbstractHashMap.HashMapIterator hashIterator() {
        return new HashIterator();
    }

    private Entry<V> getEntry(int key) {
        Entry<V>[] table = this.table;
        int index = HashUtil.indexFor(key, table.length, this.mask);
        Entry e = table[index];
        while (e != null) {
            if (e.key == key) {
                this.moveToTop(e);
                return e;
            }
            e = e.hashNext;
        }
        return null;
    }

    private void allocateTable(int length) {
        this.table = new Entry[length];
        this.mask = (1 << MathUtil.integerLogarithm(this.table.length)) - 1;
    }

    private void moveToTop(Entry<V> e) {
        Entry<V> top = this.top;
        if (top != e) {
            Entry prev = ((Entry)e).previous;
            Entry next = ((Entry)e).next;
            prev.next = next;
            if (next != null) {
                next.previous = prev;
            } else {
                this.back = prev;
            }
            ((Entry)top).previous = (Entry)e;
            ((Entry)e).next = (Entry)top;
            ((Entry)e).previous = null;
            this.top = e;
        }
    }

    private void unlink(Entry<V> e) {
        Entry prev = ((Entry)e).previous;
        Entry next = ((Entry)e).next;
        if (prev != null) {
            prev.next = next;
        } else {
            this.top = next;
        }
        if (next != null) {
            next.previous = prev;
        } else {
            this.back = prev;
        }
    }

    private void rehash(int capacity) {
        int length = HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor));
        this.capacity = capacity;
        if (length != this.table.length) {
            this.allocateTable(length);
            Entry<V>[] table = this.table;
            int mask = this.mask;
            Entry e = this.back;
            while (e != null) {
                int index = HashUtil.indexFor(e.key, length, mask);
                e.hashNext = (Entry)table[index];
                table[index] = e;
                e = e.previous;
            }
        }
    }

    private final class HashIterator
    extends AbstractHashMap.HashMapIterator {
        private Entry<V> e;
        private Entry<V> last;

        private HashIterator() {
            this.e = IntLinkedHashMap.this.top;
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            IntLinkedHashMap.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry<V> nextEntry() {
            this.last = this.e;
            Entry result = this.last;
            this.e = result.next;
            return result;
        }
    }

    private static class Entry<V>
    implements Map.Entry<Integer, V> {
        private final int key;
        private V value;
        private Entry<V> next;
        private Entry<V> previous;
        private Entry<V> hashNext;

        private Entry(int key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Integer getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V result = this.value;
            this.value = value;
            return result;
        }
    }
}

