/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;

public class SpinAllocator<T> {
    private static final int MAXIMUM_ALLOCATIONS = 50;
    private final AtomicBoolean[] employed;
    private final T[] objects;
    private final ICreator<T> creator;
    private final IDisposer<T> disposer;

    public SpinAllocator(ICreator<T> creator, @Nullable IDisposer<T> disposer) {
        this(creator, disposer, 50);
    }

    public SpinAllocator(ICreator<T> creator, IDisposer<T> disposer, int maxAllocations) {
        this.creator = creator;
        this.disposer = disposer;
        this.employed = new AtomicBoolean[maxAllocations];
        this.objects = new Object[maxAllocations];
        for (int i = 0; i < maxAllocations; ++i) {
            this.employed[i] = new AtomicBoolean(false);
        }
    }

    public T alloc() {
        for (int i = 0; i < 50; ++i) {
            if (this.employed[i].getAndSet(true)) continue;
            T result = this.objects[i];
            if (result == null) {
                this.objects[i] = result = this.creator.createInstance();
            }
            return result;
        }
        return this.creator.createInstance();
    }

    public void dispose(T instance) {
        for (int i = 0; i < 50; ++i) {
            if (this.objects[i] != instance) continue;
            if (!this.employed[i].get()) {
                throw new RuntimeException("Instance is already disposed.");
            }
            if (this.disposer != null) {
                this.disposer.disposeInstance(instance);
            }
            this.employed[i].set(false);
            return;
        }
    }

    public static interface IDisposer<T> {
        public void disposeInstance(T var1);
    }

    public static interface ICreator<T> {
        public T createInstance();
    }
}

