/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.ecsRuntime.kubernetes;

import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.AasK8SJavaProxy;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SJavaProxy;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SRequest;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.ProxyType;
import de.iip_ecosphere.platform.support.TimeUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import org.junit.Test;

public class WorkerAasJavaK8SProxy {
    private static int localPort = 6443;
    private static int vabPort = 5511;
    private static int aasPort = 6611;
    private static String serverIP = "Empty";
    private static String serverPort = "8811";
    private static boolean tlsCheck = false;
    private static ArrayList<ServerSocket> serverSocketList = new ArrayList();

    public static int getLocalPort() {
        return localPort;
    }

    public static void setLocalPort(int localPort) {
        WorkerAasJavaK8SProxy.localPort = localPort;
    }

    public static String getServerIP() {
        return serverIP;
    }

    public static void setServerIP(String serverIP) {
        WorkerAasJavaK8SProxy.serverIP = serverIP;
    }

    public static String getServerPort() {
        return serverPort;
    }

    public static void setServerPort(String serverPort) {
        WorkerAasJavaK8SProxy.serverPort = serverPort;
    }

    public int getVabPort() {
        return vabPort;
    }

    public void setVabPort(int vabPort) {
        WorkerAasJavaK8SProxy.vabPort = vabPort;
    }

    public int getAasPort() {
        return aasPort;
    }

    public void setAasPort(int aasPort) {
        WorkerAasJavaK8SProxy.aasPort = aasPort;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            serverIP = args[0];
            System.out.println("Api Server IP:" + serverIP);
        } else {
            System.out.println("No Api Server IP passed");
        }
        if (args.length > 1) {
            tlsCheck = Boolean.parseBoolean(args[1]);
            if (tlsCheck) {
                System.out.println("Security option Enabled");
            } else {
                System.out.println("Security option Disabled");
            }
        } else {
            System.out.println("No security option passed, default false");
        }
        Thread requestThread = new Thread(){

            @Override
            public void run() {
                AasK8SJavaProxy aasK8SJavaProxy = new AasK8SJavaProxy(ProxyType.WorkerProxy, aasPort, serverIP, serverPort, tlsCheck);
                try {
                    WorkerAasJavaK8SProxy.startMultiThreaded((K8SJavaProxy)aasK8SJavaProxy, localPort);
                }
                catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
                    System.err.println("Exception in the starting the multi-threads method");
                    e.printStackTrace();
                }
            }
        };
        requestThread.start();
        while (true) {
            if (new File("/tmp/EndClientRun.k8s").exists()) {
                try {
                    serverSocketList.get(0).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            TimeUtils.sleep((int)1);
        }
    }

    @Test(timeout=100000L)
    public void mainTest() {
        tlsCheck = Boolean.valueOf(System.getProperty("tlsCheck"));
        AasK8SJavaProxy aasK8SJavaProxy = new AasK8SJavaProxy(ProxyType.WorkerProxy, aasPort, serverIP, serverPort, tlsCheck);
        try {
            WorkerAasJavaK8SProxy.startMultiThreaded((K8SJavaProxy)aasK8SJavaProxy, localPort);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
            System.err.println("Exception in the starting the multi-threads method");
            e.printStackTrace();
        }
        while (true) {
            TimeUtils.sleep((int)1);
        }
    }

    public static void startMultiThreaded(final K8SJavaProxy aasK8SJavaProxy, int localPort) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, InvalidKeySpecException, IOException {
        if (new File("/tmp/EndClientRun.k8s").exists()) {
            System.out.println("/tmp/EndClientRun.k8s is exist and stop the Client");
            return;
        }
        ServerSocket serverSocket = aasK8SJavaProxy.getServerSocket(localPort, null, null, null, tlsCheck);
        serverSocketList.add(serverSocket);
        System.out.println("Started multi-threaded server at localhost port " + localPort);
        File file = new File("ClientReady.k8s");
        file.createNewFile();
        while (true) {
            final Socket socket = serverSocket.accept();
            Thread requestThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    InputStream reader = null;
                    FilterOutputStream writer = null;
                    try {
                        K8SRequest request;
                        do {
                            reader = socket.getInputStream();
                            writer = new BufferedOutputStream(socket.getOutputStream());
                            byte[] requestByte = aasK8SJavaProxy.extractK8SRequestByte(reader);
                            if (requestByte == null) return;
                            request = aasK8SJavaProxy.createK8SRequest(requestByte);
                            byte[] responseString = aasK8SJavaProxy.sendK8SRequest((BufferedOutputStream)writer, request);
                            if (responseString == null || responseString.length == 0) {
                                System.out.println(request.getPath());
                                System.out.println("Empty response");
                            }
                            writer.write(responseString);
                            ((BufferedOutputStream)writer).flush();
                        } while (!request.getPath().contains("&watch=true"));
                        return;
                    }
                    catch (SocketException e) {
                        if (e.getMessage().contentEquals("Socket input is already shutdown")) {
                            System.out.println(e.getMessage());
                            return;
                        } else {
                            System.err.println("SocketException while creating response");
                            e.printStackTrace();
                        }
                        return;
                    }
                    catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                        System.err.println("Exception while creating response");
                        e.printStackTrace();
                        System.out.println("socket thread ends Throwable");
                        return;
                    }
                    finally {
                        try {
                            writer.close();
                            reader.close();
                        }
                        catch (IOException e) {
                            System.err.println("Could not close the streams");
                            e.printStackTrace();
                        }
                    }
                }
            };
            requestThread.start();
        }
    }
}

