/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.deviceMgt.Credentials;
import de.iip_ecosphere.platform.ecsRuntime.ContainerState;
import de.iip_ecosphere.platform.ecsRuntime.EcsClient;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.iip_aas.SubmodelElementsCollectionClient;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;

public class EcsAasClient
extends SubmodelElementsCollectionClient
implements EcsClient {
    public EcsAasClient(String resourceId) throws IOException {
        super("resources", resourceId);
    }

    @Override
    public String addContainer(URI location) throws ExecutionException {
        return JsonResultWrapper.fromJson((Object)this.getOperation("addContainer").invoke(new Object[]{location.toString()}));
    }

    @Override
    public void startContainer(String id) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("startContainer").invoke(new Object[]{id}));
    }

    @Override
    public void stopContainer(String id) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("stopContainer").invoke(new Object[]{id}));
    }

    @Override
    public void migrateContainer(String id, String resourceId) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("migrateContainer").invoke(new Object[]{id, resourceId}));
    }

    @Override
    public void undeployContainer(String id) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("undeployContainer").invoke(new Object[]{id}));
    }

    @Override
    public Credentials createRemoteConnectionCredentials() throws ExecutionException {
        String result = (String)this.getOperation("createRemoteConnectionCredentials").invoke(new Object[0]);
        ObjectMapper mapper = new ObjectMapper();
        Credentials credentials = null;
        try {
            credentials = (Credentials)mapper.readValue(result, Credentials.class);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return credentials;
    }

    @Override
    public String getRuntimeName() throws ExecutionException {
        return this.getPropertyStringValue("runtimeName", "");
    }

    @Override
    public Integer getRuntimeVersion() throws ExecutionException {
        return Integer.parseInt(this.getPropertyStringValue("runtimeVersion", "-1"));
    }

    @Override
    public void updateContainer(String id, URI location) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("updateContainer").invoke(new Object[]{id, location.toString()}));
    }

    @Override
    public ContainerState getState(String id) {
        ContainerState result = ContainerState.UNKNOWN;
        try {
            String tmp = JsonResultWrapper.fromJson((Object)this.getOperation("getState").invoke(new Object[]{id}));
            if (null != tmp) {
                result = ContainerState.valueOf(tmp);
            }
        }
        catch (ExecutionException e) {
            this.getLogger().error("Requesting service state: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.getLogger().error("Requesting service state, illegal response value: " + e.getMessage());
        }
        return result;
    }

    @Override
    public String getContainerSystemName() {
        return this.getPropertyStringValue("containerSystemName", "");
    }

    @Override
    public String getContainerSystemVersion() {
        return this.getPropertyStringValue("containerSystemVersion", "");
    }

    @Override
    public SubmodelElementCollection getContainers() {
        return this.getSubmodel().getSubmodelElementCollection("containers");
    }

    @Override
    public String addContainerAsTask(String taskId, URI location) throws ExecutionException {
        return JsonResultWrapper.fromJson((Object)this.getOperation("addContainerAsTask").invoke(new Object[]{location.toString(), taskId}));
    }

    @Override
    public void startContainerAsTask(String taskId, String id) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("startContainerAsTask").invoke(new Object[]{id, taskId}));
    }

    @Override
    public void stopContainerAsTask(String taskId, String id) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.getOperation("stopContainerAsTask").invoke(new Object[]{id, taskId}));
    }

    @Override
    public String getId(URI location) {
        try {
            return (String)this.getOperation("getId").invoke(new Object[]{location.toString()});
        }
        catch (ExecutionException e) {
            this.getLogger().error("Requesting service container id: " + e.getMessage());
            return null;
        }
    }
}

