/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime;

import de.iip_ecosphere.platform.ecsRuntime.BasicContainerDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.ContainerDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.ContainerManager;
import de.iip_ecosphere.platform.ecsRuntime.ContainerState;
import de.iip_ecosphere.platform.ecsRuntime.EcsAas;
import de.iip_ecosphere.platform.ecsRuntime.EcsFactory;
import de.iip_ecosphere.platform.ecsRuntime.EcsSetup;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.UriResolver;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public abstract class AbstractContainerManager<C extends ContainerDescriptor>
implements ContainerManager {
    private Map<String, C> containers = Collections.synchronizedMap(new HashMap());

    @Override
    public Set<String> getIds() {
        return this.containers.keySet();
    }

    public Collection<C> getContainers() {
        return this.containers.values();
    }

    public C getContainer(String id) {
        return (C)((ContainerDescriptor)this.containers.get(id));
    }

    @Override
    public String getId(URI location) {
        String result = null;
        URI loc = location.normalize();
        for (ContainerDescriptor desc : this.containers.values()) {
            if (!desc.getUri().equals(loc)) continue;
            result = desc.getId();
            break;
        }
        return result;
    }

    @Override
    public ContainerState getState(String id) {
        ContainerState result = ContainerState.UNKNOWN;
        if (null != id) {
            ContainerDescriptor d = (ContainerDescriptor)this.containers.get(id);
            if (null != d) {
                result = d.getState();
            } else {
                try {
                    String uriId = new URI(id).normalize().toString();
                    for (ContainerDescriptor desc : this.containers.values()) {
                        if (!desc.getUri().toString().equals(uriId)) continue;
                        result = desc.getState();
                        break;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    protected String addContainer(String id, C descriptor) throws ExecutionException {
        this.checkId(id, "id");
        if (this.containers.containsKey(id)) {
            this.throwExecutionException(null, "Container id '" + id + "' is already known");
        }
        this.containers.put(id, descriptor);
        EcsAas.notifyContainerAdded(descriptor);
        return id;
    }

    @Override
    public void undeployContainer(String id) throws ExecutionException {
        ContainerDescriptor desc;
        this.checkId(id, "id");
        if (!this.containers.containsKey(id)) {
            this.throwExecutionException("Undeploying container " + id, "Container is not known. Cannot migrate container.");
        }
        if (ContainerState.AVAILABLE == (desc = (ContainerDescriptor)this.containers.get(id)).getState() || ContainerState.STOPPED == desc.getState()) {
            this.containers.remove(id);
            EcsAas.notifyContainerRemoved(desc);
        } else {
            this.throwExecutionException("Undeploying container " + id, "Container is in state " + String.valueOf((Object)desc.getState()) + ". Cannot undeploy container.");
        }
    }

    protected void setState(BasicContainerDescriptor container, ContainerState state) throws ExecutionException {
        ContainerState.validateTransition(container.getState(), state);
        container.setState(state);
        EcsAas.notifyContainerStateChanged(container);
    }

    protected C getContainer(String id, String idText, String activityText) throws ExecutionException {
        Optional<ContainerDescriptor> fallback;
        this.checkId(id, idText);
        ContainerDescriptor result = (ContainerDescriptor)this.containers.get(id);
        if (null == result && (fallback = this.containers.values().stream().filter(c -> id.equals(c.getUri().toString())).findAny()).isPresent()) {
            result = fallback.get();
        }
        if (null == result) {
            this.throwExecutionException(null, "Container id '" + id + "' is not known. Cannot " + activityText + " container.");
        }
        return (C)result;
    }

    protected void checkId(String id, String text) throws ExecutionException {
        if (null == id || id.length() == 0) {
            this.throwExecutionException(null, "Container " + text + "must be given (not null or empty)");
        }
    }

    @Override
    public void migrateContainer(String id, String resourceId) throws ExecutionException {
        ContainerDescriptor desc;
        this.checkId(id, "id");
        if (!this.containers.containsKey(id)) {
            this.throwExecutionException("Migrating container " + id, "Container is not known. Cannot migrate container.");
        }
        if (ContainerState.DEPLOYED == (desc = (ContainerDescriptor)this.containers.get(id)).getState()) {
            this.stopContainer(id);
        } else {
            this.throwExecutionException("Migrating container " + id, "Container is in state " + String.valueOf((Object)desc.getState()) + ". Cannot undeploy container.");
        }
    }

    protected void throwExecutionException(String action, Throwable th) throws ExecutionException {
        action = action != null && ((String)action).length() > 0 ? (String)action + ":" : "";
        LoggerFactory.getLogger(this.getClass()).error((String)action + th.getMessage());
        throw new ExecutionException(th);
    }

    protected void throwExecutionException(String action, String message) throws ExecutionException {
        action = action != null && ((String)action).length() > 0 ? (String)action + ":" : "";
        LoggerFactory.getLogger(this.getClass()).error((String)action + message);
        throw new ExecutionException(message, null);
    }

    protected File resolveUri(URI uri, File downloadDir) throws IOException {
        EcsSetup setup = EcsFactory.getSetup();
        File result = null;
        List<String> infixes = setup.getArtifactInfixes();
        for (String infix : infixes) {
            Object tmp = uri.toString();
            int pos = ((String)tmp).lastIndexOf(46);
            if (pos > 0) {
                while (infix.startsWith("-")) {
                    infix = infix.substring(1);
                }
                tmp = ((String)tmp).substring(0, pos) + "-" + infix + ((String)tmp).substring(pos);
                try {
                    result = UriResolver.resolveToFile((URI)new URI((String)tmp), (File)downloadDir);
                    if (result.exists()) break;
                    result = null;
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).info("Cannot resolve {}. Trying with further artifact infixes from {} or the base URI {}", new Object[]{tmp, uri, infixes});
                }
                catch (URISyntaxException e) {
                    LoggerFactory.getLogger(this.getClass()).info("Cannot resolve {} as this is not an URI ({}). Trying with further artifact infixes from {} or the base URI {}", new Object[]{tmp, e.getMessage(), uri, infixes});
                }
                continue;
            }
            LoggerFactory.getLogger(this.getClass()).warn("Cannot apply artifact infixes {} as base URI does not seem to point to a file.", infixes, (Object)uri);
            break;
        }
        if (null == result) {
            result = UriResolver.resolveToFile((URI)uri, (File)downloadDir);
        }
        return result;
    }
}

