/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime;

import de.iip_ecosphere.platform.ecsRuntime.DeviceManagement;
import de.iip_ecosphere.platform.ecsRuntime.EcsAas;
import de.iip_ecosphere.platform.ecsRuntime.EcsFactory;
import de.iip_ecosphere.platform.ecsRuntime.EcsSetup;
import de.iip_ecosphere.platform.ecsRuntime.Monitor;
import de.iip_ecosphere.platform.support.PidLifecycleDescriptor;
import de.iip_ecosphere.platform.support.TerminatingLifecycleDescriptor;
import de.iip_ecosphere.platform.support.iip_aas.AbstractAasLifecycleDescriptor;
import de.iip_ecosphere.platform.support.iip_aas.IipVersion;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;
import de.iip_ecosphere.platform.support.net.NetworkManagerSetup;
import de.iip_ecosphere.platform.transport.Transport;
import java.util.concurrent.ExecutionException;

public class EcsLifecycleDescriptor
extends AbstractAasLifecycleDescriptor
implements PidLifecycleDescriptor,
TerminatingLifecycleDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EcsLifecycleDescriptor.class);
    private boolean registered = false;
    private boolean continueWaiting = true;

    public EcsLifecycleDescriptor() {
        super("ECS", () -> EcsFactory.getSetup().getAas());
    }

    public void startup(String[] args) {
        block2: {
            System.out.println("oktoflow ECS Runtime " + IipVersion.getInstance().getVersion() + ".");
            Transport.setTransportSetup(() -> EcsFactory.getSetup().getTransport());
            EcsAas.enable();
            super.startup(args);
            EcsSetup setup = EcsFactory.getSetup();
            NetworkManagerFactory.configure((NetworkManagerSetup)setup.getNetMgr());
            Monitor.startScheduling();
            boolean autoOnOff = setup.getAutoOnOffboarding();
            try {
                DeviceManagement.addDevice(autoOnOff);
                this.registered = true;
            }
            catch (ExecutionException e) {
                if (autoOnOff) break block2;
                this.continueWaiting = false;
                LOGGER.error(e.getMessage());
            }
        }
    }

    public void shutdown() {
        block3: {
            Monitor.stopScheduling();
            EcsAas.notifyResourceRemoved();
            EcsSetup setup = EcsFactory.getSetup();
            boolean autoOnOff = setup.getAutoOnOffboarding();
            if (this.registered) {
                try {
                    DeviceManagement.removeDevice(autoOnOff);
                }
                catch (ExecutionException e) {
                    if (autoOnOff) break block3;
                    LOGGER.error(e.getMessage());
                }
            }
        }
        super.shutdown();
    }

    public String getPidFileName() {
        return "iip-ecsRuntime.pid";
    }

    public boolean continueWaiting() {
        return this.continueWaiting;
    }
}

